package io.lsn.logbook.configuration;

import io.lsn.logbook.configuration.entity.LogProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.BodyFilters;

import java.util.Set;
import java.util.stream.Collectors;

@Configuration
@EnableConfigurationProperties({LogProperties.class})
public class LogConfiguration {

    @Bean
    public BodyFilter bodyFilter(LogProperties logProperties) {
        Set<String> set = logProperties.getJsonExclusions().stream().collect(Collectors.toSet());
        return BodyFilters.replaceJsonStringProperty(set, "<secret>");
    }
}
