package io.linkrunner.sdk.network

import io.linkrunner.sdk.models.request.*
import io.linkrunner.sdk.models.response.BaseResponse
import io.linkrunner.sdk.models.response.AttributionDataResponse
import io.linkrunner.sdk.models.request.IntegrationRequest
import retrofit2.Response
import retrofit2.http.*

/**
 * Retrofit service interface for LinkRunner API
 */
internal interface ApiService {
    /**
     * Initialize the SDK with the server
     */
    @POST("api/client/init")
    suspend fun initialize(@Body request: InitRequest): Response<BaseResponse>
    
    /**
     * Trigger an action on the server
     */
    @POST("api/client/trigger")
    suspend fun trigger(@Body request: TriggerRequest): Response<BaseResponse>
    
    /**
     * Set user data for the current session
     */
    @POST("api/client/set-user-data")
    suspend fun setUserData(@Body request: SetUserDataRequest): Response<BaseResponse>
    
    /**
     * Capture a payment event
     */
    @POST("api/client/capture-payment")
    suspend fun capturePayment(@Body request: CapturePaymentApiRequest): Response<BaseResponse>
    
    /**
     * Remove a previously captured payment
     */
    @POST("api/client/remove-captured-payment")
    suspend fun removePayment(@Body request: RemovePaymentApiRequest): Response<BaseResponse>
    
    /**
     * Track a custom event
     */
    @POST("api/client/capture-event")
    suspend fun trackEvent(@Body request: TrackEventApiRequest): Response<BaseResponse>
    
    /**
     * Get the current user's profile
     */
    @GET("api/client/getProfile")
    suspend fun getProfile(@Query("token") token: String): Response<BaseResponse>
    
    /**
     * Get attribution data for the current installation
     */
    @POST("api/client/attribution-data")
    suspend fun getAttributionData(@Body request: InitRequest): Response<AttributionDataResponse>

    /**
     * Update user's push notification token
     */
    @POST("api/client/update-push-token")
    suspend fun updatePushToken(@Body request: UpdatePushTokenRequest): Response<BaseResponse>
    
    /**
     * Log an error or warning
     */
    @POST("api/client/log")
    suspend fun log(@Body body: Map<String, Any?>): Response<BaseResponse>


    /**
     * Update integration data (e.g., Clevertap ID)
     */
    @POST("api/client/integrations")
    suspend fun updateIntegrations(@Body request: IntegrationRequest): Response<BaseResponse>
}
