package io.linkrunner.sdk.models.response

import com.google.gson.annotations.SerializedName
import io.linkrunner.sdk.models.response.IPLocationData as IpLocationData
/**
 * Response model for attribution data
 */
data class AttributionDataResponse(
    @SerializedName("msg") val message: String,
    @SerializedName("status") val status: Int,
    @SerializedName("data") val data: AttributionData
)

/**
 * Attribution data model
 */
data class AttributionData(
    @SerializedName("deeplink") val deeplink: String?,
    @SerializedName("campaign_data") val campaignData: CampaignData
)

/**
 * Campaign data model
 */
data class CampaignData(
    @SerializedName("id") val id: String,
    @SerializedName("name") val name: String,
    @SerializedName("ad_network") val adNetwork: String?,
    @SerializedName("type") val type: String,
    @SerializedName("installed_at") val installedAt: String,
    @SerializedName("store_click_at") val storeClickAt: String?,
    @SerializedName("group_name") val groupName: String,
    @SerializedName("asset_name") val assetName: String,
    @SerializedName("asset_group_name") val assetGroupName: String
)