package io.linkrunner.sdk.models

import androidx.annotation.Keep

@Keep
data class IntegrationData(
    var clevertapId: String? = null
) {

    fun isEmpty(): Boolean {
        return clevertapId == null
    }

    /**
     * Converts the IntegrationData object to a Map for API requests
     * @return Map with integration data properties
     */
    fun toMap(): Map<String, Any> {
        val map = mutableMapOf<String, Any>()

        clevertapId?.let { map["clevertap_id"] = it }

        return map
    }
}