/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.logging.slf4j.uncaught.exception.handler;

import io.liftwizard.logging.slf4j.mdc.MultiMDCCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Slf4jUncaughtExceptionHandler.class);

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        try (MultiMDCCloseable mdc = new MultiMDCCloseable();){
            mdc.put("threadName", thread.getName());
            mdc.put("exceptionClass", throwable.getClass().getCanonicalName());
            mdc.put("exceptionMessage", throwable.getMessage());
            mdc.put("liftwizard.error.thread", thread.getName());
            mdc.put("liftwizard.error.kind", throwable.getClass().getCanonicalName());
            mdc.put("liftwizard.error.message", throwable.getMessage());
            String message = "Exception in thread \"" + thread.getName() + "\"";
            LOGGER.warn(message, throwable);
            System.err.print(message);
            System.err.print(" ");
            throwable.printStackTrace(System.err);
        }
    }
}

