/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.junit.extension.match.file;

import io.liftwizard.junit.extension.match.AbstractMatchExtension;
import io.liftwizard.junit.extension.match.FileSlurper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class FileMatchExtension
extends AbstractMatchExtension {
    public FileMatchExtension(@Nonnull Class<?> callingClass) {
        super(callingClass);
    }

    protected void assertFileContentsOrThrow(@Nonnull String resourceClassPathLocation, @Nonnull String actualString) throws URISyntaxException, IOException {
        if (this.resourceRerecorderExtension.mustRerecord(resourceClassPathLocation)) {
            String prettyPrintedString = this.getPrettyPrintedString(actualString);
            Path packagePath = this.resourceRerecorderExtension.getPackagePath();
            File resourceFile = packagePath.resolve(resourceClassPathLocation).toFile();
            this.resourceRerecorderExtension.writeStringToFile(resourceClassPathLocation, prettyPrintedString, resourceFile);
            if (!this.rerecordEnabled) {
                String detailMessage = resourceClassPathLocation + " did not exist. Created it.";
                this.errorCollectorExtension.addError(new AssertionError((Object)detailMessage));
            }
        } else {
            InputStream inputStream = this.callingClass.getResourceAsStream(resourceClassPathLocation);
            String expectedStringFromFile = FileSlurper.slurp((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (!actualString.equals(expectedStringFromFile)) {
                String detailMessage = this.resourceRerecorderExtension.handleMismatch(resourceClassPathLocation, actualString);
                AssertionError assertionError = new AssertionError((Object)detailMessage);
                this.errorCollectorExtension.addError(assertionError);
            }
        }
    }

    protected String getPrettyPrintedString(@Nonnull String string) {
        return string;
    }
}

