/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.upload;

import io.leopard.upload.Base64MultipartFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class LeopardMultipartResolver
extends CommonsMultipartResolver {
    private static final String[] NAMES = new String[]{"picture", "file", "image", "icon1", "icon2", "icon3"};

    protected CommonsFileUploadSupport.MultipartParsingResult parseFileItems(List<FileItem> fileItems, String encoding) {
        CommonsFileUploadSupport.MultipartParsingResult result = super.parseFileItems(fileItems, encoding);
        for (String fieldName : NAMES) {
            String content;
            if (result.getMultipartFiles().get((Object)fieldName) != null) break;
            FileItem item = this.find(fileItems, fieldName);
            if (item == null || StringUtils.isEmpty((Object)(content = item.getString())) || !content.startsWith("data:image")) continue;
            List<MultipartFile> list = this.toList(result, fieldName, content);
            result.getMultipartFiles().put((Object)fieldName, list);
        }
        return result;
    }

    protected FileItem find(List<FileItem> fileItems, String fieldName) {
        for (FileItem item : fileItems) {
            if (!fieldName.equals(item.getFieldName())) continue;
            return item;
        }
        return null;
    }

    protected List<MultipartFile> toList(CommonsFileUploadSupport.MultipartParsingResult result, String name, String content) {
        ArrayList<MultipartFile> list = new ArrayList<MultipartFile>();
        Base64MultipartFile file = new Base64MultipartFile(content);
        list.add(file);
        result.getMultipartFiles().put((Object)name, list);
        return list;
    }
}

