/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.upload;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Base64Utils;
import org.springframework.web.multipart.MultipartFile;

public class Base64MultipartFile
implements MultipartFile {
    private byte[] data;
    private String extName;
    private String contentType;

    public Base64MultipartFile(String content) {
        if (StringUtils.isEmpty((String)content)) {
            throw new NullPointerException("\u56fe\u7247\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (!content.startsWith("data:image")) {
            throw new IllegalArgumentException("\u975e\u6cd5\u56fe\u7247\u683c\u5f0f.");
        }
        if (content.startsWith("data:image/png;base64,")) {
            this.data = Base64Utils.decodeFromString((String)content.substring(22));
            this.extName = "png";
        } else if (content.startsWith("data:image/gif;base64,")) {
            this.data = Base64Utils.decodeFromString((String)content.substring(22));
            this.extName = "gif";
        } else if (content.startsWith("data:image/jpeg;base64,")) {
            this.data = Base64Utils.decodeFromString((String)content.substring(23));
            this.extName = "jpg";
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u56fe\u7247\u7c7b\u578b[" + StringUtils.substring((String)content, (int)0, (int)30) + "].");
        }
    }

    public String getName() {
        return "base64." + this.extName;
    }

    public String getOriginalFilename() {
        return "base64." + this.extName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return false;
    }

    public long getSize() {
        return this.data.length;
    }

    public byte[] getBytes() throws IOException {
        return this.data;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("not impl.");
    }
}

