/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.timer;

import io.leopard.timer.Period;
import java.util.Calendar;

public class WeekPeriod
implements Period {
    private final int weekday;
    private final int hour;
    private final int minute;
    private final int second;

    public WeekPeriod(int weekday, int hour, int minute) {
        this.weekday = weekday;
        this.hour = hour;
        this.minute = minute;
        this.second = 0;
    }

    public int getSeconds() {
        Calendar cld = Calendar.getInstance();
        cld.set(7, this.weekday + 1);
        cld.set(11, this.hour);
        cld.set(12, this.minute);
        cld.set(13, this.second);
        long time = cld.getTimeInMillis();
        long diff = time - System.currentTimeMillis();
        if (diff <= 0L) {
            diff += 604800000L;
        }
        int seconds = (int)(diff / 1000L);
        return seconds;
    }

    @Override
    public boolean sleep() throws InterruptedException {
        int seconds = this.getSeconds();
        if (seconds <= 0) {
            seconds = 1;
        }
        long mills = seconds * 1000;
        Thread.sleep(mills);
        return true;
    }
}

