/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.timer;

import io.leopard.timer.Period;
import io.leopard.timer.Timer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerUtil {
    protected static final Log logger = LogFactory.getLog((String)("TIMERLOG." + TimerUtil.class.getName()));

    public static List<Thread> start(final Timer timer) {
        if (!timer.isEnabled()) {
            logger.info((Object)("\u5f53\u524d\u670d\u52a1\u5668\u4e0d\u542f\u7528\u5b9a\u65f6\u5668[" + timer.getClass().getSimpleName() + "]\u3002"));
            return null;
        }
        int threadCount = timer.getThreadCount();
        if (threadCount < 1) {
            throw new IllegalArgumentException("\u5b9a\u65f6\u5668\u7ebf\u7a0b\u6570\u4e0d\u80fd\u5c0f\u4e8e1.");
        }
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < threadCount; ++i) {
            String threadName = timer.getClass().getSimpleName() + "-" + i;
            Thread thread = new Thread(threadName){

                @Override
                public void run() {
                    TimerUtil.run(timer);
                }
            };
            thread.start();
            threadList.add(thread);
        }
        return threadList;
    }

    public static void run(Timer timer) {
        boolean isContinue;
        do {
            Period period;
            if ((period = timer.getPeriod()) == null) {
                throw new NullPointerException("\u5b9a\u65f6\u5668\u95f4\u9694\u5468\u671f\u6ca1\u6709\u8bbe\u7f6e.");
            }
            isContinue = false;
            try {
                isContinue = period.sleep();
                timer.start();
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        } while (isContinue);
    }
}

