/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.timer;

import io.leopard.timer.Period;
import java.util.Calendar;

public class PerHourPeriod
implements Period {
    private final int minute;
    private final int second;

    public PerHourPeriod(int minute) {
        this.minute = minute;
        this.second = 0;
    }

    public int getSeconds() {
        Calendar cld = Calendar.getInstance();
        cld.set(12, this.minute);
        cld.set(13, this.second);
        long diff = cld.getTimeInMillis() - System.currentTimeMillis();
        if (diff <= 0L) {
            diff += 3600000L;
        }
        int seconds = (int)(diff / 1000L);
        return seconds;
    }

    @Override
    public boolean sleep() throws InterruptedException {
        int seconds = this.getSeconds();
        if (seconds <= 0) {
            seconds = 1;
        }
        long mills = seconds * 1000;
        Thread.sleep(mills);
        return true;
    }
}

