/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.timer;

import io.leopard.timer.Period;
import java.util.Calendar;

public class PerDayPeriod
implements Period {
    private final int hour;
    private final int minute;
    private final int second;

    public PerDayPeriod(int hour, int minute) {
        this(hour, minute, 0);
    }

    public PerDayPeriod(int hour, int minute, int second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public int getSeconds() {
        Calendar cld = Calendar.getInstance();
        cld.set(11, this.hour);
        cld.set(12, this.minute);
        cld.set(13, this.second);
        long diff = cld.getTimeInMillis() - System.currentTimeMillis();
        if (diff <= 0L) {
            diff += 86400000L;
        }
        int seconds = (int)(diff / 1000L);
        return seconds;
    }

    @Override
    public boolean sleep() throws InterruptedException {
        int seconds = this.getSeconds();
        if (seconds <= 0) {
            seconds = 1;
        }
        long mills = seconds * 1000;
        Thread.sleep(mills);
        return true;
    }
}

