/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data.queue;

import io.leopard.data.queue.IConsumer;
import io.leopard.data.queue.Queue;
import io.leopard.redis.RedisImpl;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class QueueRedisImpl
implements Queue,
InitializingBean,
DisposableBean {
    private Log logger = LogFactory.getLog(this.getClass());
    private RedisImpl redis;
    protected String server;
    protected String password;

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void afterPropertiesSet() throws Exception {
        this.redis = new RedisImpl(this.server, 16, 10000);
        this.redis.init();
    }

    public void destroy() {
        this.redis.destroy();
    }

    @Override
    public void publish(String routingKey, String message) {
        this.redis.rpush(routingKey, new String[]{message});
    }

    @Override
    public void subscribe(final String queue, final IConsumer callback) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    QueueRedisImpl.this.subscribe2(queue, callback);
                }
                catch (Exception e) {
                    QueueRedisImpl.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }, 0L, 1000L);
    }

    private void subscribe2(String queue, IConsumer callback) {
        String message;
        while ((message = this.redis.lpop(queue)) != null) {
            try {
                callback.consume(message);
            }
            catch (Exception e) {
                this.logger.error((Object)("message:" + message));
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

