/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data4j.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.WriteResult;
import com.mongodb.gridfs.GridFS;
import io.leopard.data4j.mongo.Mongo;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MongoImpl
implements Mongo {
    private String server;
    private String database;
    private String collectionName;
    private MongoClient client;
    private DBCollection collection;
    private DB db;

    public MongoImpl() {
    }

    public MongoImpl(String server, String database, String collectionName) {
        this.server = server;
        this.database = database;
        this.collectionName = collectionName;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void init() {
        String[] list = this.server.split(":");
        String host = list[0];
        int port = Integer.parseInt(list[1]);
        try {
            this.client = new MongoClient(host, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.db = this.client.getDB(this.database);
        this.collection = this.db.getCollection(this.collectionName);
    }

    public void destroy() {
        this.client.close();
    }

    @Override
    public boolean insert(Object bean) {
        List<Field> fieldList = MongoImpl.listFields(bean);
        BasicDBObject obj = new BasicDBObject();
        for (Field field : fieldList) {
            Object value;
            String name = field.getName();
            field.setAccessible(true);
            try {
                value = field.get(bean);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            obj.put(name, value);
        }
        this.collection.insert(new DBObject[]{obj});
        return true;
    }

    public static List<Field> listFields(Object bean) {
        ArrayList<Field> list = new ArrayList<Field>();
        Class<?> currentClazz = bean.getClass();
        while (true) {
            Field[] fields;
            for (Field field : fields = currentClazz.getDeclaredFields()) {
                list.add(field);
            }
            if (currentClazz.getSuperclass() == null) break;
            currentClazz = currentClazz.getSuperclass();
        }
        return list;
    }

    @Override
    public <T> T query() {
        return null;
    }

    @Override
    public boolean drop() {
        this.collection.drop();
        return true;
    }

    @Override
    public <T> List<T> find(Mongo.IFind find, Class<T> clazz) {
        DBCursor cursor = find.find(this.collection);
        return this.toBeanList(cursor, clazz);
    }

    @Override
    public <T> List<T> find(DBObject ref, Class<T> clazz, int start, int size) {
        DBCursor cursor = this.collection.find(ref).skip(start).limit(size);
        return this.toBeanList(cursor, clazz);
    }

    public <T> List<T> toBeanList(DBCursor cursor, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        while (cursor.hasNext()) {
            T bean;
            DBObject user = cursor.next();
            try {
                bean = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Map map = user.toMap();
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                String fieldName = (String)entry.getKey();
                Object value = entry.getValue();
                if ("_id".equals(fieldName)) continue;
                if ("location".equals(fieldName)) {
                    BasicDBList dbList = (BasicDBList)value;
                    double x = (Double)dbList.get(0);
                    double y = (Double)dbList.get(1);
                    double[] geo = new double[]{x, y};
                    value = geo;
                }
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(bean, value);
                }
                catch (Exception e) {
                    System.out.println("value:" + value + " " + value.getClass().getName());
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            list.add(bean);
        }
        return list;
    }

    @Override
    public boolean truncate() {
        WriteResult resulst = this.collection.remove((DBObject)new BasicDBObject());
        return resulst.getN() > 0;
    }

    @Override
    public boolean remove(DBObject ref) {
        WriteResult resulst = this.collection.remove(ref);
        return resulst.getN() > 0;
    }

    @Override
    public boolean remove(String fieldName, Object value) {
        return this.remove((DBObject)new BasicDBObject(fieldName, value));
    }

    @Override
    public boolean update(DBObject q, DBObject o) {
        WriteResult resulst = this.collection.update(q, o);
        return resulst.getN() > 0;
    }

    @Override
    public GridFS getGridFS(String type) {
        return new GridFS(this.db, "fs");
    }
}

