/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data4j.pubsub;

import io.leopard.data4j.pubsub.IPubSub;
import io.leopard.data4j.pubsub.PubSubRsyncImpl;
import io.leopard.redis.Redis;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Publisher {
    private static Map<IPubSub, PubSubRsyncImpl> map = new ConcurrentHashMap<IPubSub, PubSubRsyncImpl>();

    public static void listen(final IPubSub pub, Redis redis) {
        if (map.containsKey(pub)) {
            throw new IllegalArgumentException("Pub[" + pub + "]\u5df2\u7ecf\u76d1\u542c\u8fc7.");
        }
        String channel = Publisher.getChannel(pub);
        PubSubRsyncImpl pubRsyncImpl = new PubSubRsyncImpl(redis, channel){

            @Override
            public void subscribe(String message, boolean isMySelf) {
                pub.subscribe(message, isMySelf);
            }
        };
        pubRsyncImpl.init();
        map.put(pub, pubRsyncImpl);
    }

    protected static String getChannel(IPubSub pub) {
        Class<?> clazz = pub.getClass();
        String classSimpleName = clazz.getSimpleName();
        return "pubsub:" + classSimpleName;
    }

    public static boolean publish(IPubSub pub, String message) {
        PubSubRsyncImpl pubRsyncImpl = map.get(pub);
        return pubRsyncImpl.publish(message);
    }
}

