/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data4j.memdb;

import io.leopard.data4j.memdb.MemdbRsyncQueue;
import io.leopard.data4j.memdb.QueueBean;
import io.leopard.data4j.memdb.SerializeImpl;
import redis.clients.jedis.JedisPubSub;

public class QueueListener
extends JedisPubSub {
    private final MemdbRsyncQueue memdbRsyncQueue;
    private final String sender;

    public QueueListener(MemdbRsyncQueue memdbRsyncQueue, String sender) {
        this.memdbRsyncQueue = memdbRsyncQueue;
        this.sender = sender;
    }

    public void onMessage(String channel, String message) {
        QueueBean queueBean = SerializeImpl.getInstance().toObject(message, QueueBean.class);
        boolean isMySelf = this.sender.equals(queueBean.getSender());
        this.memdbRsyncQueue.add(queueBean.getType(), queueBean.getKey(), queueBean.getValue(), isMySelf);
    }

    public void onSubscribe(String channel, int subscribedChannels) {
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
    }

    public void onPSubscribe(String pattern, int subscribedChannels) {
    }

    public void onPUnsubscribe(String pattern, int subscribedChannels) {
    }

    public void onPMessage(String pattern, String channel, String message) {
        System.out.println(pattern + "=" + channel + "=" + message);
    }
}

