/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data4j.memdb;

import io.leopard.data4j.memdb.MemdbRsyncQueue;
import io.leopard.data4j.memdb.MemdbRsyncService;
import io.leopard.data4j.memdb.QueueBean;
import io.leopard.data4j.memdb.QueueListener;
import io.leopard.data4j.memdb.SerializeImpl;
import io.leopard.redis.Redis;
import redis.clients.jedis.JedisPubSub;

public class MemdbRsyncServiceRedisImpl
implements MemdbRsyncService {
    private final Redis redis;
    private final String channel;
    private final String sender;
    private final QueueListener queueListener;

    public MemdbRsyncServiceRedisImpl(Redis redis, String channel, MemdbRsyncQueue memdbRsyncQueue) {
        this.redis = redis;
        this.channel = channel;
        this.sender = Integer.toString(redis.hashCode());
        this.queueListener = new QueueListener(memdbRsyncQueue, this.sender);
    }

    @Override
    public boolean add(String type, String key, String value, boolean isMySelf) {
        QueueBean queueBean = new QueueBean();
        queueBean.setType(type);
        queueBean.setKey(key);
        queueBean.setValue(value);
        queueBean.setSender(this.sender);
        this.redis.publish(this.channel, SerializeImpl.getInstance().serialize(queueBean));
        return true;
    }

    @Override
    public void init() {
        new Thread(){

            @Override
            public void run() {
                MemdbRsyncServiceRedisImpl.this.redis.subscribe((JedisPubSub)MemdbRsyncServiceRedisImpl.this.queueListener, new String[]{MemdbRsyncServiceRedisImpl.this.channel});
            }
        }.start();
    }

    @Override
    public void destroy() {
    }
}

