/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data4j.pubsub;

import io.leopard.data4j.pubsub.IPubSub;
import io.leopard.data4j.pubsub.Publisher;
import io.leopard.redis.Redis;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class PubSubBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    protected ConfigurableListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    protected Redis getRedis() {
        Redis redis = this.findRedis();
        if (redis == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230redis\u8fde\u63a5 .");
        }
        return redis;
    }

    protected Redis findRedis() {
        Redis redis = this.findRedisBySessionRedis();
        if (redis != null) {
            return redis;
        }
        return null;
    }

    protected Redis findRedisBySessionRedis() {
        try {
            return (Redis)this.beanFactory.getBean("sessionRedis");
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof IPubSub) {
            System.err.println("beanName:" + beanName + " bean:" + bean);
            Publisher.listen((IPubSub)bean, this.getRedis());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

