/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data4j.memdb;

import io.leopard.data4j.memdb.MemdbLruImpl;
import io.leopard.data4j.memdb.MemdbRsyncQueue;
import io.leopard.data4j.memdb.MemdbRsyncService;
import io.leopard.data4j.memdb.MemdbRsyncServiceRedisImpl;
import io.leopard.redis.Redis;

public class MemdbRsyncImpl
extends MemdbLruImpl
implements MemdbRsyncQueue {
    protected MemdbRsyncService memdbRsyncService;
    private Redis redis;
    private String channel = "memdb_queue:default";

    public MemdbRsyncImpl(int maxSize) {
        super(maxSize);
    }

    public void setRedis(Redis redis) {
        this.redis = redis;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Override
    public void init() {
        this.memdbRsyncService = new MemdbRsyncServiceRedisImpl(this.redis, this.channel, this);
        this.memdbRsyncService.init();
    }

    @Override
    public void destroy() {
        this.memdbRsyncService.destroy();
    }

    @Override
    public boolean set(String key, String value) {
        boolean success = super.set(key, value);
        this.memdbRsyncService.add("set", key, value, false);
        return success;
    }

    @Override
    public boolean remove(String key) {
        boolean success = super.remove(key);
        this.memdbRsyncService.add("remove", key, null, false);
        return success;
    }

    @Override
    public boolean add(String type, String key, String value, boolean isMySelf) {
        if ("set".equals(type)) {
            super.set(key, value);
            return true;
        }
        if ("remove".equals(type)) {
            super.remove(key);
            return true;
        }
        IllegalArgumentException e = new IllegalArgumentException("\u672a\u77e5\u6d88\u606f\u7c7b\u578b[" + type + " key:" + key + "].");
        this.logger.error((Object)e.getMessage(), (Throwable)e);
        return false;
    }
}

