/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data.dfs.service.image;

import io.leopard.data.dfs.service.DfsService;
import io.leopard.data.dfs.service.image.ImageFileInfo;
import io.leopard.data.dfs.service.image.ThumbnailService;
import io.leopard.data.dfs.service.image.ThumbnailUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThumbnailServiceSizeImpl
implements ThumbnailService {
    @Autowired
    private DfsService dfsService;

    @Override
    public byte[] read(String filename) throws IOException {
        ImageFileInfo imageFileInfo = ThumbnailUtil.parse(filename);
        if (imageFileInfo == null) {
            throw new FileNotFoundException("\u975e\u6cd5\u6587\u4ef6\u540d[" + filename + "]");
        }
        String originalName = imageFileInfo.getOriginalName();
        byte[] data = this.dfsService.read(originalName);
        long uid = 0L;
        return this.small(uid, originalName, imageFileInfo.getSize(), data);
    }

    protected byte[] small(long uid, String uri, String size, byte[] data) throws IOException {
        String[] list = size.split("x");
        int width = Integer.parseInt(list[0]);
        int height = Integer.parseInt(list[1]);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        Thumbnails.of((InputStream[])new InputStream[]{input}).size(width, height).toOutputStream((OutputStream)output);
        String uri2 = uri.replaceFirst(".jpg", "_" + size + ".jpg");
        byte[] data2 = output.toByteArray();
        if (data2.length <= 0) {
            throw new FileNotFoundException("\u600e\u4e48\u538b\u7f29\u540e\u7684\u56fe\u7247\u4f1a\u4e3a\u7a7a[" + uri2 + "]?");
        }
        this.dfsService.write(uri2, data2, uid);
        return data2;
    }

    public boolean isSizeFilename(String filename) {
        return ThumbnailUtil.isMatcher(filename);
    }
}

