/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data.dfs.service.image;

import io.leopard.data.dfs.service.DfsService;
import io.leopard.data.dfs.service.image.ThumbnailService;
import io.leopard.data.dfs.service.image.ThumbnailServiceCropImpl;
import io.leopard.data.dfs.service.image.ThumbnailServiceSizeImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThumbnailServiceImpl
implements ThumbnailService {
    @Autowired
    private ThumbnailService thumbnailServiceSizeImpl;
    @Autowired
    private ThumbnailService thumbnailServiceCropImpl;
    @Autowired
    private DfsService dfsService;

    @Override
    public byte[] read(String filename) throws IOException {
        try {
            return this.dfsService.read(filename);
        }
        catch (FileNotFoundException e) {
            if (((ThumbnailServiceCropImpl)this.thumbnailServiceCropImpl).isCropFilename(filename)) {
                return this.thumbnailServiceCropImpl.read(filename);
            }
            if (((ThumbnailServiceSizeImpl)this.thumbnailServiceSizeImpl).isSizeFilename(filename)) {
                return this.thumbnailServiceSizeImpl.read(filename);
            }
            throw e;
        }
    }
}

