/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data.dfs;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import io.leopard.data.dfs.Dfs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DfsGridImpl
implements Dfs,
InitializingBean,
DisposableBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String server;
    private MongoClient client;
    private GridFS fs;

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void afterPropertiesSet() throws Exception {
    }

    protected GridFS getGridFS() {
        if (this.fs == null) {
            this.fs = this.loadGridFS();
        }
        return this.fs;
    }

    private synchronized GridFS loadGridFS() {
        if (this.fs != null) {
            return this.fs;
        }
        String[] list = this.server.split(":");
        String host = list[0];
        int port = Integer.parseInt(list[1]);
        String username = null;
        String password = null;
        if (list.length >= 4) {
            username = list[2];
            password = list[3];
        }
        int connectTimeout = 60000;
        MongoClientOptions options = new MongoClientOptions.Builder().connectTimeout(connectTimeout).build();
        this.client = new MongoClient(new ServerAddress(host, port), options);
        DB db = this.client.getDB("dfs");
        if (username != null && username.length() > 0 && password != null && password.length() > 0) {
            db.addUser(username, password.toCharArray());
        }
        return new GridFS(db, "fs");
    }

    public void destroy() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    @Override
    public boolean delete(String filename) {
        this.getGridFS().remove(filename);
        return true;
    }

    @Override
    public boolean create(String filename, byte[] data) {
        this.delete(filename);
        GridFSInputFile file = this.getGridFS().createFile(data);
        file.setFilename(filename);
        file.save();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(String filename) throws IOException {
        GridFSDBFile file = this.getGridFS().findOne(filename);
        if (file == null) {
            throw new FileNotFoundException(filename);
        }
        try (InputStream input = file.getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)input);
            return byArray;
        }
    }
}

