/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data.dfs;

import io.leopard.data.dfs.Dfs;
import io.leopard.data.dfs.DfsFileImpl;
import io.leopard.data.dfs.DfsGridImpl;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DfsCacheImpl
implements Dfs,
InitializingBean,
DisposableBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private DfsGridImpl dfsGridImpl;
    private DfsFileImpl dfsFileImpl;
    private String server;

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void afterPropertiesSet() throws Exception {
        this.dfsGridImpl = new DfsGridImpl();
        this.dfsGridImpl.setServer(this.server);
        this.dfsGridImpl.afterPropertiesSet();
        this.dfsFileImpl = new DfsFileImpl();
        this.dfsFileImpl.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        this.dfsGridImpl.destroy();
        this.dfsFileImpl.destroy();
    }

    @Override
    public boolean create(String filename, byte[] data) {
        this.dfsFileImpl.create(filename, data);
        return this.dfsGridImpl.create(filename, data);
    }

    @Override
    public byte[] read(String filename) throws IOException {
        try {
            return this.dfsFileImpl.read(filename);
        }
        catch (IOException e) {
            byte[] data = this.dfsGridImpl.read(filename);
            this.dfsFileImpl.create(filename, data);
            return data;
        }
    }

    @Override
    public boolean delete(String filename) {
        this.dfsFileImpl.delete(filename);
        return this.dfsGridImpl.delete(filename);
    }
}

