/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data.dfs.service.image;

import io.leopard.data.dfs.service.DfsService;
import io.leopard.data.dfs.service.image.ImageFileInfo;
import io.leopard.data.dfs.service.image.ThumbnailService;
import io.leopard.data.dfs.service.image.ThumbnailUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThumbnailServiceCropImpl
implements ThumbnailService {
    @Autowired
    private DfsService dfsService;

    @Override
    public byte[] read(String filename) throws IOException {
        String filename2 = filename.replace("_crop.jpg", ".jpg");
        ImageFileInfo imageFileInfo = ThumbnailUtil.parse(filename2);
        if (imageFileInfo == null) {
            throw new FileNotFoundException("\u975e\u6cd5\u6587\u4ef6\u540d[" + filename + "]");
        }
        String originalName = imageFileInfo.getOriginalName();
        byte[] data = this.dfsService.read(originalName);
        long uid = 0L;
        return this.crop(uid, originalName, imageFileInfo.getSize(), data);
    }

    protected byte[] crop(long uid, String uri, String size, byte[] data) throws IOException {
        if (data.length <= 0) {
            throw new IllegalArgumentException("\u56fe\u7247\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String[] list = size.split("x");
        int width = Integer.parseInt(list[0]);
        int height = Integer.parseInt(list[1]);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        Thumbnails.of((InputStream[])new InputStream[]{input}).crop((Position)Positions.CENTER).size(width, height).keepAspectRatio(true).toOutputStream((OutputStream)output);
        String uri2 = uri.replaceFirst(".jpg", "_" + size + "_crop.jpg");
        byte[] data2 = output.toByteArray();
        this.dfsService.write(uri2, data2, uid);
        return data2;
    }

    public boolean isCropFilename(String filename) {
        return filename.endsWith("_crop.jpg");
    }
}

