/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data.dfs.service.image;

import io.leopard.data.dfs.UrlMultipartFile;
import io.leopard.data.dfs.service.DfsService;
import io.leopard.data.dfs.service.image.ImageDfsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartFile;

public class ImageDfsServiceSyncImpl
implements ImageDfsService {
    protected Log logger = LogFactory.getLog(this.getClass());
    @Resource
    private DfsService dfsService;

    @Override
    public String save(long uid, String folder, MultipartFile file, String sizeList, int width, int height) throws IOException {
        String uri = this.save(uid, folder, file, sizeList);
        if (uri != null && width > 0 && height > 0) {
            uri = uri + "#" + width + "_" + height;
        }
        return uri;
    }

    @Override
    public String save(long uid, String folder, MultipartFile file, String sizeList) throws IOException {
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String uri = file instanceof UrlMultipartFile ? ((UrlMultipartFile)file).getName() : this.save(uid, folder, file.getBytes(), sizeList);
        return uri;
    }

    @Override
    public List<String> save(long uid, String folder, List<MultipartFile> pictureList, String sizeList) throws IOException {
        ArrayList<String> imageUrlList = new ArrayList<String>();
        if (pictureList != null) {
            for (MultipartFile file : pictureList) {
                String uri = this.save(uid, folder, file, sizeList);
                if (uri == null) continue;
                imageUrlList.add(uri);
            }
        }
        return imageUrlList;
    }

    @Override
    public String save(long uid, String folder, byte[] data, String sizeList) throws IOException {
        String uri = folder + ImageDfsServiceSyncImpl.uuid() + ".jpg";
        this.saveByUri(uid, uri, data, sizeList);
        return uri;
    }

    protected String saveByUri(long uid, String uri, byte[] data, String sizeList) throws IOException {
        this.dfsService.write(uri, data, uid);
        if (sizeList != null && sizeList.length() > 0) {
            String[] list;
            for (String size : list = sizeList.split(",")) {
                size = size.trim();
            }
        }
        return uri;
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "").toLowerCase();
    }
}

