/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data.dfs.service.image;

import io.leopard.data.dfs.service.image.ImageDfsServiceSyncImpl;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.SystemUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class ImageDfsServiceImpl
extends ImageDfsServiceSyncImpl {
    protected boolean isWeb() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return false;
        }
        HttpServletRequest request = attributes.getRequest();
        return request != null;
    }

    @Override
    public String save(final long uid, String folder, final byte[] data, final String sizeList) throws IOException {
        if (SystemUtils.IS_OS_WINDOWS && !this.isWeb()) {
            return super.save(uid, folder, data, sizeList);
        }
        final String uri = folder + ImageDfsServiceImpl.uuid() + ".jpg";
        this.logger.info((Object)("async save:" + uri));
        new Thread(){

            @Override
            public void run() {
                try {
                    ImageDfsServiceImpl.this.saveByUri(uid, uri, data, sizeList);
                    ImageDfsServiceImpl.this.logger.info((Object)("save:" + uri));
                }
                catch (IOException e) {
                    ImageDfsServiceImpl.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }.start();
        return uri;
    }
}

