/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.data.dfs.service.image;

import io.leopard.data.dfs.service.image.ThumbnailService;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ImageController {
    protected Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private ThumbnailService thumbnailService;

    @RequestMapping
    public void image(HttpServletRequest request, HttpServletResponse response) {
        byte[] data;
        String filename = request.getParameter("f");
        if (filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        filename = filename.replaceFirst("/file/", "/");
        try {
            data = this.thumbnailService.read(filename);
        }
        catch (Exception e) {
            this.logger.error((Object)("filename:" + filename + " message:" + e.getMessage()), (Throwable)e);
            byte[] body = e.toString().getBytes();
            this.write(response, "text/plain", 404, body);
            return;
        }
        this.write(response, "image/jpeg", 200, data);
    }

    protected void write(HttpServletResponse response, String contentType, int status, byte[] data) {
        int contentLength = data.length;
        response.setStatus(status);
        response.setContentLength(contentLength);
        response.setContentType(contentType);
        response.setDateHeader("Expires", System.currentTimeMillis() + 3600000L);
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

