/*
 * Decompiled with CFR 0.152.
 */
package io.kvision.remote;

import io.kvision.remote.HttpMethod;
import io.kvision.remote.KVServerRequest;
import io.kvision.remote.KVServiceManager;
import io.kvision.remote.KotlinxObjectDeSerializerKt;
import jakarta.annotation.PostConstruct;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.function.server.ServerResponseExtensionsKt;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u0011H\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/kvision/remote/KVHandler;", "", "services", "", "Lio/kvision/remote/KVServiceManager;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Ljava/util/List;Lorg/springframework/context/ApplicationContext;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "serializersModules", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModules", "()Ljava/util/List;", "getServices", "threadLocalRequest", "Ljava/lang/ThreadLocal;", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "handle", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "request", "(Lorg/springframework/web/reactive/function/server/ServerRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleSse", "init", "", "serverRequest", "kvision-server-spring-boot"})
@SourceDebugExtension(value={"SMAP\nKVRouterConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KVRouterConfiguration.kt\nio/kvision/remote/KVHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1855#2,2:125\n*S KotlinDebug\n*F\n+ 1 KVRouterConfiguration.kt\nio/kvision/remote/KVHandler\n*L\n81#1:125,2\n*E\n"})
public class KVHandler {
    @NotNull
    private final List<KVServiceManager<?>> services;
    @NotNull
    private final ApplicationContext applicationContext;
    @Autowired(required=false)
    @Nullable
    private final List<SerializersModule> serializersModules;
    @NotNull
    private final ThreadLocal<ServerRequest> threadLocalRequest;

    public KVHandler(@NotNull List<? extends KVServiceManager<?>> services, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.services = services;
        this.applicationContext = applicationContext;
        this.threadLocalRequest = new ThreadLocal();
    }

    @NotNull
    public final List<KVServiceManager<?>> getServices() {
        return this.services;
    }

    @NotNull
    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Nullable
    public final List<SerializersModule> getSerializersModules() {
        return this.serializersModules;
    }

    @PostConstruct
    public void init() {
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KVServiceManager it = (KVServiceManager)((Object)element$iv);
            boolean bl = false;
            it.setDeSerializer(KotlinxObjectDeSerializerKt.kotlinxObjectDeSerializer(this.serializersModules));
        }
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public ServerRequest serverRequest() {
        ServerRequest serverRequest = this.threadLocalRequest.get();
        if (serverRequest == null) {
            serverRequest = new KVServerRequest();
        }
        return serverRequest;
    }

    @Nullable
    public Object handle(@NotNull ServerRequest request, @NotNull Continuation<? super ServerResponse> $completion) {
        return KVHandler.handle$suspendImpl(this, request, $completion);
    }

    static /* synthetic */ Object handle$suspendImpl(KVHandler $this, ServerRequest request, Continuation<? super ServerResponse> $completion) {
        Function4<ServerRequest, ThreadLocal<ServerRequest>, ApplicationContext, Continuation<? super ServerResponse>, Object> function4 = KVHandler.handle$getHandler(request, $this);
        if (function4 == null) {
            ServerResponse.HeadersBuilder headersBuilder = ServerResponse.notFound();
            Intrinsics.checkNotNullExpressionValue((Object)headersBuilder, (String)"notFound(...)");
            return ServerResponseExtensionsKt.buildAndAwait((ServerResponse.HeadersBuilder)headersBuilder, $completion);
        }
        return function4.invoke((Object)request, $this.threadLocalRequest, (Object)$this.applicationContext, $completion);
    }

    @Nullable
    public Object handleSse(@NotNull ServerRequest request, @NotNull Continuation<? super ServerResponse> $completion) {
        return KVHandler.handleSse$suspendImpl(this, request, $completion);
    }

    static /* synthetic */ Object handleSse$suspendImpl(KVHandler $this, ServerRequest request, Continuation<? super ServerResponse> $completion) {
        Function4<ServerRequest, ThreadLocal<ServerRequest>, ApplicationContext, Continuation<? super ServerResponse>, Object> function4 = KVHandler.handleSse$getSseHandler(request, $this);
        if (function4 == null) {
            ServerResponse.HeadersBuilder headersBuilder = ServerResponse.notFound();
            Intrinsics.checkNotNullExpressionValue((Object)headersBuilder, (String)"notFound(...)");
            return ServerResponseExtensionsKt.buildAndAwait((ServerResponse.HeadersBuilder)headersBuilder, $completion);
        }
        return function4.invoke((Object)request, $this.threadLocalRequest, (Object)$this.applicationContext, $completion);
    }

    private static final Function4<ServerRequest, ThreadLocal<ServerRequest>, ApplicationContext, Continuation<? super ServerResponse>, Object> handle$getHandler(ServerRequest $request, KVHandler this$0) {
        String string = $request.method().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String springMethod = string;
        HttpMethod httpMethod = HttpMethod.Companion.fromStringOrNull(springMethod);
        if (httpMethod == null) {
            return null;
        }
        HttpMethod kvMethod = httpMethod;
        String string2 = $request.path();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path(...)");
        String routeUrl = string2;
        return (Function4)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this$0.services), (Function1)new Function1<KVServiceManager<?>, Function4<? super ServerRequest, ? super ThreadLocal<ServerRequest>, ? super ApplicationContext, ? super Continuation<? super ServerResponse>, ? extends Object>>(kvMethod, routeUrl){
            final /* synthetic */ HttpMethod $kvMethod;
            final /* synthetic */ String $routeUrl;
            {
                this.$kvMethod = $kvMethod;
                this.$routeUrl = $routeUrl;
                super(1);
            }

            @Nullable
            public final Function4<ServerRequest, ThreadLocal<ServerRequest>, ApplicationContext, Continuation<? super ServerResponse>, Object> invoke(@NotNull KVServiceManager<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Function4)it.getRouteMapRegistry().findHandler(this.$kvMethod, this.$routeUrl);
            }
        }));
    }

    private static final Function4<ServerRequest, ThreadLocal<ServerRequest>, ApplicationContext, Continuation<? super ServerResponse>, Object> handleSse$getSseHandler(ServerRequest $request, KVHandler this$0) {
        String string = $request.path();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path(...)");
        String routeUrl = string;
        return (Function4)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this$0.services), (Function1)new Function1<KVServiceManager<?>, Function4<? super ServerRequest, ? super ThreadLocal<ServerRequest>, ? super ApplicationContext, ? super Continuation<? super ServerResponse>, ? extends Object>>(routeUrl){
            final /* synthetic */ String $routeUrl;
            {
                this.$routeUrl = $routeUrl;
                super(1);
            }

            @Nullable
            public final Function4<ServerRequest, ThreadLocal<ServerRequest>, ApplicationContext, Continuation<? super ServerResponse>, Object> invoke(@NotNull KVServiceManager<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Function4)it.getSseRequests().get(this.$routeUrl);
            }
        }));
    }
}

