/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.channels;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuationImplKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.channels.AbstractChannel;
import kotlinx.coroutines.channels.AbstractChannelKt;
import kotlinx.coroutines.channels.AbstractSendChannel;
import kotlinx.coroutines.channels.ArrayBufferState;
import kotlinx.coroutines.channels.ArrayChannelState;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Closed;
import kotlinx.coroutines.channels.Receive;
import kotlinx.coroutines.channels.ReceiveOrClosed;
import kotlinx.coroutines.channels.Send;
import kotlinx.coroutines.internal.AtomicKt;
import kotlinx.coroutines.internal.OnUndeliveredElementKt;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.internal.UndeliveredElementException;
import kotlinx.coroutines.selects.SelectInstance;
import kotlinx.coroutines.selects.SelectKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012 \u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\n\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0014J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0015\u0010%\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010&J!\u0010'\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00028\u00002\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0014\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0011H\u0014J\n\u0010-\u001a\u0004\u0018\u00010\"H\u0014J\u0016\u0010.\u001a\u0004\u0018\u00010\"2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0014J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lkotlinx/coroutines/channels/ArrayChannel;", "E", "Lkotlinx/coroutines/channels/AbstractChannel;", "capacity", "", "onBufferOverflow", "Lkotlinx/coroutines/channels/BufferOverflow;", "onUndeliveredElement", "Lkotlin/Function1;", "", "Lkotlinx/coroutines/internal/OnUndeliveredElement;", "(ILkotlinx/coroutines/channels/BufferOverflow;Lkotlin/jvm/functions/Function1;)V", "bufferDebugString", "", "getBufferDebugString", "()Ljava/lang/String;", "isBufferAlwaysEmpty", "", "()Z", "isBufferAlwaysFull", "isBufferEmpty", "isBufferFull", "isClosedForReceive", "isEmpty", "state", "Lkotlinx/coroutines/channels/ArrayChannelState;", "enqueueElement", "currentSize", "element", "(ILjava/lang/Object;)V", "enqueueReceiveInternal", "receive", "Lkotlinx/coroutines/channels/Receive;", "enqueueSend", "", "send", "Lkotlinx/coroutines/channels/Send;", "offerInternal", "(Ljava/lang/Object;)Ljava/lang/Object;", "offerSelectInternal", "select", "Lkotlinx/coroutines/selects/SelectInstance;", "(Ljava/lang/Object;Lkotlinx/coroutines/selects/SelectInstance;)Ljava/lang/Object;", "onCancelIdempotent", "wasClosed", "pollInternal", "pollSelectInternal", "updateBufferSize", "Lkotlinx/coroutines/internal/Symbol;", "kotlinx-coroutines-core"})
public class ArrayChannel<E>
extends AbstractChannel<E> {
    private final int capacity;
    @NotNull
    private final BufferOverflow onBufferOverflow;
    @NotNull
    private final ArrayChannelState state;

    public ArrayChannel(int capacity, @NotNull BufferOverflow onBufferOverflow, @Nullable Function1<? super E, Unit> onUndeliveredElement) {
        super(onUndeliveredElement);
        this.capacity = capacity;
        this.onBufferOverflow = onBufferOverflow;
        int n = this.capacity >= 1 ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "ArrayChannel capacity must be at least 1, but " + this.capacity + " was specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.capacity;
        n2 = 8;
        bl = false;
        this.state = new ArrayChannelState(Math.min(n, n2));
    }

    @Override
    protected final boolean isBufferAlwaysEmpty() {
        return false;
    }

    @Override
    protected final boolean isBufferEmpty() {
        return this.state.getSize() == 0;
    }

    @Override
    protected final boolean isBufferAlwaysFull() {
        return false;
    }

    @Override
    protected final boolean isBufferFull() {
        return this.state.getSize() == this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            bl2 = this.isEmptyImpl();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosedForReceive() {
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            bl2 = super.isClosedForReceive();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected Object offerInternal(E element) {
        Object receive2 = null;
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            int size2 = this.state.getSize();
            Object object = this.getClosedForSend();
            if (object != null) {
                Closed<?> closed = object;
                boolean bl5 = false;
                boolean bl6 = false;
                Closed<?> it = closed;
                boolean bl7 = false;
                return it;
            }
            object = this.updateBufferSize(size2);
            if (object != null) {
                ReceiveOrClosed<E> receiveOrClosed = object;
                boolean bl8 = false;
                boolean bl9 = false;
                ReceiveOrClosed<E> it = receiveOrClosed;
                boolean bl10 = false;
                return it;
            }
            if (size2 == 0) {
                while ((object = this.takeFirstReceiveOrPeekClosed()) != null) {
                    receive2 = object;
                    if (receive2 instanceof Closed) {
                        this.state.setSize(size2);
                        return receive2;
                    }
                    Symbol token2 = receive2.tryResumeReceive(element, null);
                    if (token2 == null) continue;
                    boolean bl11 = false;
                    if (DebugKt.getASSERTIONS_ENABLED()) {
                        boolean bl12 = false;
                        if (!(token2 == CancellableContinuationImplKt.RESUME_TOKEN)) {
                            throw new AssertionError();
                        }
                    }
                    this.state.setSize(size2);
                    Unit unit = Unit.INSTANCE;
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 6] lbl43 : MonitorExitStatement: MONITOREXIT : this_$iv
                    receive2.completeResumeReceive(element);
                    return receive2.getOfferResult();
                }
            }
            this.enqueueElement(size2, element);
            return AbstractChannelKt.OFFER_SUCCESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected Object offerSelectInternal(E element, @NotNull SelectInstance<?> select2) {
        Object receive2 = null;
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            int size2;
            block9: {
                boolean bl3 = false;
                boolean bl4 = false;
                size2 = this.state.getSize();
                Object object = this.getClosedForSend();
                if (object != null) {
                    Closed<?> closed = object;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Closed<?> it = closed;
                    boolean bl7 = false;
                    return it;
                }
                object = this.updateBufferSize(size2);
                if (object != null) {
                    Object object2 = object;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Object it = object2;
                    boolean bl10 = false;
                    return it;
                }
                if (size2 == 0) {
                    Object failure;
                    do {
                        AbstractSendChannel.TryOfferDesc<E> offerOp = this.describeTryOffer(element);
                        failure = select2.performAtomicTrySelect(offerOp);
                        if (failure == null) {
                            this.state.setSize(size2);
                            receive2 = offerOp.getResult();
                            Unit unit = Unit.INSTANCE;
                            // MONITOREXIT @DISABLED, blocks:[1, 2, 5, 8] lbl37 : MonitorExitStatement: MONITOREXIT : this_$iv
                            Object v0 = receive2;
                            Intrinsics.checkNotNull(v0);
                            ((ReceiveOrClosed)v0).completeResumeReceive(element);
                            return ((ReceiveOrClosed)receive2).getOfferResult();
                        }
                        if (failure == AbstractChannelKt.OFFER_FAILED) break block9;
                    } while (failure == AtomicKt.RETRY_ATOMIC);
                    if (failure != SelectKt.getALREADY_SELECTED() && !(failure instanceof Closed)) {
                        String string = Intrinsics.stringPlus("performAtomicTrySelect(describeTryOffer) returned ", failure);
                        boolean bl11 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    this.state.setSize(size2);
                    return failure;
                }
            }
            if (!select2.trySelect()) {
                this.state.setSize(size2);
                return SelectKt.getALREADY_SELECTED();
            }
            this.enqueueElement(size2, element);
            return AbstractChannelKt.OFFER_SUCCESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object enqueueSend(@NotNull Send send2) {
        Object object;
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            object = super.enqueueSend(send2);
        }
        return object;
    }

    private final Symbol updateBufferSize(int currentSize) {
        Symbol symbol;
        if (currentSize < this.capacity) {
            this.state.setSize(currentSize + 1);
            return null;
        }
        BufferOverflow bufferOverflow = this.onBufferOverflow;
        int n = WhenMappings.$EnumSwitchMapping$0[bufferOverflow.ordinal()];
        switch (n) {
            case 1: {
                symbol = AbstractChannelKt.OFFER_FAILED;
                break;
            }
            case 2: {
                symbol = AbstractChannelKt.OFFER_SUCCESS;
                break;
            }
            case 3: {
                symbol = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return symbol;
    }

    private final void enqueueElement(int currentSize, E element) {
        if (currentSize < this.capacity) {
            this.state.ensureCapacity(currentSize, this.capacity);
            this.state.setBufferAt((this.state.getHead() + currentSize) % this.state.getBufferSize(), element);
        } else {
            boolean bl = false;
            if (DebugKt.getASSERTIONS_ENABLED()) {
                boolean bl2 = false;
                if (!(this.onBufferOverflow == BufferOverflow.DROP_OLDEST)) {
                    throw new AssertionError();
                }
            }
            this.state.setBufferAt(this.state.getHead() % this.state.getBufferSize(), null);
            this.state.setBufferAt((this.state.getHead() + currentSize) % this.state.getBufferSize(), element);
            this.state.setHead((this.state.getHead() + 1) % this.state.getBufferSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object pollInternal() {
        Send send2 = null;
        boolean resumed = false;
        Object result2 = null;
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            int size2;
            block11: {
                boolean bl3 = false;
                boolean bl4 = false;
                size2 = this.state.getSize();
                if (size2 != 0) break block11;
                Closed<?> closed = this.getClosedForSend();
                Object object = closed == null ? AbstractChannelKt.POLL_FAILED : closed;
                return object;
            }
            result2 = this.state.getBufferAt(this.state.getHead());
            this.state.setBufferAt(this.state.getHead(), null);
            this.state.setSize(size2 - 1);
            Object replacement = AbstractChannelKt.POLL_FAILED;
            if (size2 == this.capacity) {
                Send send3;
                while ((send3 = this.takeFirstSendOrPeekClosed()) != null) {
                    send2 = send3;
                    AbstractSendChannel this_$iv2 = this;
                    boolean $i$f$disposeQueue$kotlinx_coroutines_core = false;
                    boolean bl5 = false;
                    Symbol token2 = send2.tryResumeSend(null);
                    if (token2 != null) {
                        boolean bl6 = false;
                        if (DebugKt.getASSERTIONS_ENABLED()) {
                            boolean bl7 = false;
                            if (!(token2 == CancellableContinuationImplKt.RESUME_TOKEN)) {
                                throw new AssertionError();
                            }
                        }
                        resumed = true;
                        replacement = send2.getPollResult();
                        break;
                    }
                    send2.undeliveredElement();
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.state.setSize(size2);
                this.state.setBufferAt((this.state.getHead() + size2) % this.state.getBufferSize(), replacement);
            }
            this.state.setHead((this.state.getHead() + 1) % this.state.getBufferSize());
            Unit unit = Unit.INSTANCE;
        }
        if (resumed) {
            Send send4 = send2;
            Intrinsics.checkNotNull(send4);
            send4.completeResumeSend();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected Object pollSelectInternal(@NotNull SelectInstance<?> select2) {
        Object send2 = null;
        boolean success = false;
        Object result2 = null;
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            Object replacement;
            int size2;
            block11: {
                boolean bl3 = false;
                boolean bl4 = false;
                size2 = this.state.getSize();
                if (size2 == 0) {
                    Closed<?> closed = this.getClosedForSend();
                    return closed == null ? AbstractChannelKt.POLL_FAILED : closed;
                }
                result2 = this.state.getBufferAt(this.state.getHead());
                this.state.setBufferAt(this.state.getHead(), null);
                this.state.setSize(size2 - 1);
                replacement = AbstractChannelKt.POLL_FAILED;
                if (size2 == this.capacity) {
                    Object failure;
                    do {
                        AbstractChannel.TryPollDesc pollOp = this.describeTryPoll();
                        failure = select2.performAtomicTrySelect(pollOp);
                        if (failure == null) {
                            send2 = pollOp.getResult();
                            success = true;
                            Object object = send2;
                            Intrinsics.checkNotNull(object);
                            replacement = ((Send)object).getPollResult();
                            break block11;
                        }
                        if (failure == AbstractChannelKt.POLL_FAILED) break block11;
                    } while (failure == AtomicKt.RETRY_ATOMIC);
                    if (failure == SelectKt.getALREADY_SELECTED()) {
                        this.state.setSize(size2);
                        this.state.setBufferAt(this.state.getHead(), result2);
                        return failure;
                    }
                    if (!(failure instanceof Closed)) {
                        String string = Intrinsics.stringPlus("performAtomicTrySelect(describeTryOffer) returned ", failure);
                        boolean bl5 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    send2 = failure;
                    success = true;
                    replacement = failure;
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.state.setSize(size2);
                this.state.setBufferAt((this.state.getHead() + size2) % this.state.getBufferSize(), replacement);
            } else if (!select2.trySelect()) {
                this.state.setSize(size2);
                this.state.setBufferAt(this.state.getHead(), result2);
                return SelectKt.getALREADY_SELECTED();
            }
            this.state.setHead((this.state.getHead() + 1) % this.state.getBufferSize());
            Unit unit = Unit.INSTANCE;
        }
        if (!success) return result2;
        Object object = send2;
        Intrinsics.checkNotNull(object);
        ((Send)object).completeResumeSend();
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean enqueueReceiveInternal(@NotNull Receive<? super E> receive2) {
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            bl2 = super.enqueueReceiveInternal(receive2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCancelIdempotent(boolean wasClosed) {
        Function1 onUndeliveredElement = this.onUndeliveredElement;
        UndeliveredElementException undeliveredElementException = null;
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            int n = this.state.getSize();
            boolean bl5 = false;
            int n2 = 0;
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                int it = n2;
                boolean bl6 = false;
                Object value = this.state.getBufferAt(this.state.getHead());
                if (onUndeliveredElement != null && value != AbstractChannelKt.EMPTY) {
                    undeliveredElementException = OnUndeliveredElementKt.callUndeliveredElementCatchingException(onUndeliveredElement, value, undeliveredElementException);
                }
                this.state.setBufferAt(this.state.getHead(), null);
                this.state.setHead((this.state.getHead() + 1) % this.state.getBufferSize());
            }
            this.state.setSize(0);
            Unit unit = Unit.INSTANCE;
        }
        super.onCancelIdempotent(wasClosed);
        UndeliveredElementException undeliveredElementException2 = undeliveredElementException;
        if (undeliveredElementException2 != null) {
            UndeliveredElementException undeliveredElementException3 = undeliveredElementException2;
            bl = false;
            boolean bl7 = false;
            UndeliveredElementException it = undeliveredElementException3;
            boolean bl8 = false;
            throw it;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected String getBufferDebugString() {
        String string;
        ArrayBufferState this_$iv = this.state;
        boolean $i$f$withLock = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            string = "(buffer:capacity=" + this.capacity + ",size=" + this.state.getSize() + ')';
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BufferOverflow.values().length];
            nArray[BufferOverflow.SUSPEND.ordinal()] = 1;
            nArray[BufferOverflow.DROP_LATEST.ordinal()] = 2;
            nArray[BufferOverflow.DROP_OLDEST.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

