/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.collections.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableList;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/ktor/util/collections/internal/ConcurrentListSlice;", "T", "Lkotlin/collections/AbstractMutableList;", "origin", "", "fromIndex", "", "toIndex", "(Ljava/util/List;II)V", "size", "getSize", "()I", "add", "", "index", "element", "(ILjava/lang/Object;)V", "get", "(I)Ljava/lang/Object;", "removeAt", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "ktor-utils"})
public final class ConcurrentListSlice<T>
extends AbstractMutableList<T> {
    @NotNull
    private final List<T> origin;
    private final int fromIndex;
    private final int toIndex;

    public ConcurrentListSlice(@NotNull List<T> origin2, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        this.origin = origin2;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    public int getSize() {
        return Math.min(this.origin.size(), this.toIndex - this.fromIndex);
    }

    @Override
    public T get(int index) {
        return this.origin.get(this.fromIndex + index);
    }

    @Override
    public void add(int index, T element) {
        throw new IllegalStateException("Unsupported append in ConcurrentList slice".toString());
    }

    @Override
    public T removeAt(int index) {
        throw new IllegalStateException("Unsupported remove in ConcurrentList slice".toString());
    }

    @Override
    public T set(int index, T element) {
        return this.origin.set(this.fromIndex + index, element);
    }
}

