/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.controller;

import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.extended.generic.GenericKubernetesApi;
import io.kubernetes.client.informer.ListerWatcher;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformer;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformers;
import io.kubernetes.client.util.CallGeneratorParams;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.Watchable;
import io.kubernetes.client.util.generic.KubernetesApiResponse;
import io.kubernetes.client.util.generic.options.ListOptions;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;

@Component
public class KubernetesInformerFactoryProcessor
implements BeanDefinitionRegistryPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(KubernetesInformerFactoryProcessor.class);
    public static final int ORDER = 0;
    private BeanDefinitionRegistry beanDefinitionRegistry;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ApiClient apiClient;
        Optional sharedInformerFactoryBeanName;
        try {
            Map sharedInformerFactories = beanFactory.getBeansOfType(SharedInformerFactory.class);
            if (sharedInformerFactories.size() > 1) {
                log.warn("More than sharedInformerFactory registered..");
                return;
            }
            sharedInformerFactoryBeanName = sharedInformerFactories.keySet().stream().findFirst();
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error("No sharedInformerFactory bean registered..");
            return;
        }
        if (!sharedInformerFactoryBeanName.isPresent()) {
            log.info("No sharedInformerFactory selected, skipping informers constructing..");
            return;
        }
        try {
            apiClient = (ApiClient)beanFactory.getBean(ApiClient.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            log.info("No ApiClient bean found, falling-back to default initialization..");
            try {
                apiClient = ClientBuilder.standard().build();
            }
            catch (IOException ex) {
                log.error("failed initializing ApiClient", (Throwable)ex);
                return;
            }
        }
        apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(Duration.ZERO).build());
        SharedInformerFactory sharedInformerFactory = (SharedInformerFactory)beanFactory.getBean(SharedInformerFactory.class);
        KubernetesInformers kubernetesInformers = sharedInformerFactory.getClass().getAnnotation(KubernetesInformers.class);
        if (kubernetesInformers == null || kubernetesInformers.value().length == 0) {
            log.info("No informers registered in the sharedInformerFactory..");
            return;
        }
        for (KubernetesInformer kubernetesInformer : kubernetesInformers.value()) {
            final GenericKubernetesApi api = new GenericKubernetesApi(kubernetesInformer.apiTypeClass(), kubernetesInformer.apiListTypeClass(), kubernetesInformer.groupVersionResource().apiGroup(), kubernetesInformer.groupVersionResource().apiVersion(), kubernetesInformer.groupVersionResource().resourcePlural(), apiClient);
            SharedIndexInformer sharedIndexInformer = sharedInformerFactory.sharedIndexInformerFor(new ListerWatcher(){

                public KubernetesListObject list(final CallGeneratorParams params) throws ApiException {
                    KubernetesApiResponse resp = api.list(new ListOptions(){
                        {
                            this.setResourceVersion(params.resourceVersion);
                            this.setTimeoutSeconds(params.timeoutSeconds);
                        }
                    });
                    if (!resp.isSuccess()) {
                        throw new ApiException(resp.getHttpStatusCode(), resp.getStatus().getMessage());
                    }
                    return (KubernetesListObject)resp.getObject();
                }

                public Watchable watch(CallGeneratorParams params) throws ApiException {
                    return api.watch();
                }
            }, kubernetesInformer.apiTypeClass(), kubernetesInformer.resyncPeriodMillis());
            ResolvableType informerType = ResolvableType.forClassWithGenerics(SharedInformer.class, (Class[])new Class[]{kubernetesInformer.apiTypeClass()});
            RootBeanDefinition informerBean = new RootBeanDefinition();
            informerBean.setTargetType(informerType);
            informerBean.setAutowireMode(2);
            informerBean.setAutowireCandidate(true);
            String informerBeanName = informerType.toString();
            this.beanDefinitionRegistry.registerBeanDefinition(informerBeanName, (BeanDefinition)informerBean);
            beanFactory.registerSingleton(informerBeanName, (Object)sharedIndexInformer);
            Lister lister = new Lister(sharedIndexInformer.getIndexer());
            ResolvableType listerType = ResolvableType.forClassWithGenerics(Lister.class, (Class[])new Class[]{kubernetesInformer.apiTypeClass()});
            RootBeanDefinition listerBean = new RootBeanDefinition();
            listerBean.setTargetType(listerType);
            listerBean.setAutowireMode(2);
            listerBean.setAutowireCandidate(true);
            String listerBeanName = listerType.toString();
            this.beanDefinitionRegistry.registerBeanDefinition(listerBeanName, (BeanDefinition)listerBean);
            beanFactory.registerSingleton(listerBeanName, (Object)lister);
        }
    }

    public int getOrder() {
        return 0;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.beanDefinitionRegistry = registry;
    }
}

