/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.network;

import io.kubernetes.client.extended.network.EndpointsLoadBalancer;
import io.kubernetes.client.extended.network.LoadBalanceStrategy;
import io.kubernetes.client.spring.extended.network.annotation.KubernetesEndpointsLoadBalanced;
import io.kubernetes.client.spring.extended.network.endpoints.EndpointsGetter;
import java.lang.reflect.Field;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

public class KubernetesEndpointsLoadBalancerProcessor
implements InstantiationAwareBeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        for (Field field : beanClass.getDeclaredFields()) {
            LoadBalanceStrategy strategy;
            EndpointsGetter epGetter;
            if (!field.isAnnotationPresent(KubernetesEndpointsLoadBalanced.class)) continue;
            KubernetesEndpointsLoadBalanced loadBalanced = field.getAnnotation(KubernetesEndpointsLoadBalanced.class);
            try {
                epGetter = (EndpointsGetter)this.applicationContext.getAutowireCapableBeanFactory().getBean(loadBalanced.endpointsGetter());
            }
            catch (NoSuchBeanDefinitionException ne) {
                try {
                    epGetter = loadBalanced.endpointsGetter().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new BeanCreationException("failed creating endpoint getter instance", (Throwable)e);
                }
                this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)epGetter);
                this.applicationContext.getAutowireCapableBeanFactory().initializeBean((Object)epGetter, "endpoints-getter-" + loadBalanced.endpointsGetter().getSimpleName());
            }
            try {
                strategy = loadBalanced.strategy().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new BeanCreationException("failed creating endpoint load-balance strategy instance", (Throwable)e);
            }
            EndpointsGetter finalEpGetter = epGetter;
            EndpointsLoadBalancer loadBalancer = new EndpointsLoadBalancer(() -> finalEpGetter.get(loadBalanced.namespace(), loadBalanced.name()), strategy);
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)loadBalancer);
        }
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

