/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.controller;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.ControllerManager;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.builder.DefaultControllerBuilder;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.workqueue.DefaultRateLimitingQueue;
import io.kubernetes.client.extended.workqueue.RateLimitingQueue;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.spring.extended.controller.annotation.AddWatchEventFilter;
import io.kubernetes.client.spring.extended.controller.annotation.DeleteWatchEventFilter;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesReconciler;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesReconcilerReadyFunc;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesReconcilerWatch;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesReconcilerWatches;
import io.kubernetes.client.spring.extended.controller.annotation.UpdateWatchEventFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class KubernetesReconcilerProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(KubernetesReconcilerProcessor.class);
    private ControllerManager controllerManager;
    private ExecutorService controllerManagerDaemon = Executors.newSingleThreadExecutor();

    public int getOrder() {
        return 1;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] names;
        SharedInformerFactory sharedInformerFactory = (SharedInformerFactory)beanFactory.getBean(SharedInformerFactory.class);
        for (String name : names = beanFactory.getBeanNamesForType(Reconciler.class)) {
            Reconciler reconciler = (Reconciler)beanFactory.getBean(name);
            KubernetesReconciler kubernetesReconciler = reconciler.getClass().getAnnotation(KubernetesReconciler.class);
            String reconcilerName = kubernetesReconciler.value();
            Controller controller = this.buildController(sharedInformerFactory, reconciler);
            beanFactory.registerSingleton(reconcilerName, (Object)controller);
        }
    }

    private Controller buildController(SharedInformerFactory sharedInformerFactory, Reconciler r) throws BeansException {
        KubernetesReconciler kubernetesReconciler = r.getClass().getAnnotation(KubernetesReconciler.class);
        String reconcilerName = kubernetesReconciler.value();
        KubernetesReconcilerWatches watches = kubernetesReconciler.watches();
        DefaultControllerBuilder builder = ControllerBuilder.defaultBuilder((SharedInformerFactory)sharedInformerFactory);
        DefaultRateLimitingQueue workQueue = new DefaultRateLimitingQueue();
        builder = builder.withWorkQueue((RateLimitingQueue)workQueue);
        Map<Class, AddFilterAdaptor> addFilters = this.getAddFilters(watches, r);
        Map<Class, UpdateFilterAdaptor> updateFilters = this.getUpdateFilters(watches, r);
        Map<Class, DeleteFilterAdaptor> deleteFilters = this.getDeleteFilters(watches, r);
        List<ReadyFuncAdaptor> readyFuncs = this.getReadyFuncs(r);
        for (KubernetesReconcilerWatch watch : watches.value()) {
            try {
                Function<? extends KubernetesObject, Request> workQueueKeyFunc;
                try {
                    workQueueKeyFunc = watch.workQueueKeyFunc().getConstructor(WorkQueue.class).newInstance(workQueue);
                }
                catch (NoSuchMethodException e) {
                    workQueueKeyFunc = watch.workQueueKeyFunc().newInstance();
                }
                catch (InvocationTargetException e) {
                    throw new BeanCreationException("Failed instantiating controller watch: " + e.getMessage());
                }
                Function<? extends KubernetesObject, Request> finalWorkQueueKeyFunc = workQueueKeyFunc;
                builder = builder.watch(q -> ControllerBuilder.controllerWatchBuilder(watch.apiTypeClass(), (WorkQueue)q).withOnAddFilter((Predicate)addFilters.get(watch.apiTypeClass())).withOnUpdateFilter((BiPredicate)updateFilters.get(watch.apiTypeClass())).withOnDeleteFilter((BiPredicate)deleteFilters.get(watch.apiTypeClass())).withWorkQueueKeyFunc(finalWorkQueueKeyFunc).withResyncPeriod(Duration.ofMillis(watch.resyncPeriodMillis())).build());
                for (Supplier supplier : readyFuncs) {
                    builder = builder.withReadyFunc(supplier);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new BeanCreationException("Failed instantiating controller: " + e.getMessage());
            }
        }
        builder = builder.withWorkerCount(kubernetesReconciler.workerCount());
        return builder.withReconciler(r).withName(reconcilerName).build();
    }

    private Map<Class, AddFilterAdaptor> getAddFilters(KubernetesReconcilerWatches watches, Reconciler reconciler) {
        HashMap<Class, AddFilterAdaptor> filters = new HashMap<Class, AddFilterAdaptor>();
        HashSet<Method> allAnnotatedMethods = new HashSet<Method>();
        HashSet<Method> adoptedMethods = new HashSet<Method>();
        for (KubernetesReconcilerWatch watch : watches.value()) {
            for (Method method : reconciler.getClass().getMethods()) {
                AddWatchEventFilter annotation = method.getAnnotation(AddWatchEventFilter.class);
                if (annotation != null && watch.apiTypeClass().equals(annotation.apiTypeClass())) {
                    if (filters.containsKey(watch.apiTypeClass())) {
                        log.warn("Duplicated watch ADD event filter upon apiType {}", annotation.apiTypeClass());
                    }
                    filters.put(watch.apiTypeClass(), new AddFilterAdaptor(reconciler, method));
                    adoptedMethods.add(method);
                }
                allAnnotatedMethods.add(method);
            }
        }
        allAnnotatedMethods.removeAll(adoptedMethods);
        if (allAnnotatedMethods.size() > 0) {
            log.warn("Dangling watch ADD event filters {}", (Object)StringUtils.join(allAnnotatedMethods, (String)","));
        }
        return filters;
    }

    private Map<Class, UpdateFilterAdaptor> getUpdateFilters(KubernetesReconcilerWatches watches, Reconciler reconciler) {
        HashMap<Class, UpdateFilterAdaptor> filters = new HashMap<Class, UpdateFilterAdaptor>();
        HashSet<Method> allAnnotatedMethods = new HashSet<Method>();
        HashSet<Method> adoptedMethods = new HashSet<Method>();
        for (KubernetesReconcilerWatch watch : watches.value()) {
            for (Method method : reconciler.getClass().getMethods()) {
                UpdateWatchEventFilter annotation = method.getAnnotation(UpdateWatchEventFilter.class);
                if (annotation != null && watch.apiTypeClass().equals(annotation.apiTypeClass())) {
                    if (filters.containsKey(watch.apiTypeClass())) {
                        log.warn("Duplicated watch UPDATE event filter upon apiType {}", (Object)annotation.apiTypeClass());
                    }
                    filters.put(watch.apiTypeClass(), new UpdateFilterAdaptor(reconciler, method));
                    adoptedMethods.add(method);
                }
                allAnnotatedMethods.add(method);
            }
        }
        allAnnotatedMethods.removeAll(adoptedMethods);
        if (allAnnotatedMethods.size() > 0) {
            log.warn("Dangling watch UPDATE event filters {}", (Object)StringUtils.join(allAnnotatedMethods, (String)","));
        }
        return filters;
    }

    private Map<Class, DeleteFilterAdaptor> getDeleteFilters(KubernetesReconcilerWatches watches, Reconciler reconciler) {
        HashMap<Class, DeleteFilterAdaptor> filters = new HashMap<Class, DeleteFilterAdaptor>();
        HashSet<Method> allAnnotatedMethods = new HashSet<Method>();
        HashSet<Method> adoptedMethods = new HashSet<Method>();
        for (KubernetesReconcilerWatch watch : watches.value()) {
            for (Method method : reconciler.getClass().getMethods()) {
                DeleteWatchEventFilter annotation = method.getAnnotation(DeleteWatchEventFilter.class);
                if (annotation != null && watch.apiTypeClass().equals(annotation.apiTypeClass())) {
                    if (filters.containsKey(watch.apiTypeClass())) {
                        log.warn("Duplicated watch DELETE event filter upon apiType {}", annotation.apiTypeClass());
                    }
                    filters.put(watch.apiTypeClass(), new DeleteFilterAdaptor(reconciler, method));
                    adoptedMethods.add(method);
                }
                allAnnotatedMethods.add(method);
            }
        }
        allAnnotatedMethods.removeAll(adoptedMethods);
        if (allAnnotatedMethods.size() > 0) {
            log.warn("Dangling watch DELETE event filters {}", (Object)StringUtils.join(allAnnotatedMethods, (String)","));
        }
        return filters;
    }

    private List<ReadyFuncAdaptor> getReadyFuncs(Reconciler reconciler) {
        ArrayList<ReadyFuncAdaptor> readyFuncs = new ArrayList<ReadyFuncAdaptor>();
        for (Method method : reconciler.getClass().getMethods()) {
            if (!method.isAnnotationPresent(KubernetesReconcilerReadyFunc.class)) continue;
            readyFuncs.add(new ReadyFuncAdaptor(reconciler, method));
        }
        return readyFuncs;
    }

    private static class ReadyFuncAdaptor
    implements Supplier<Boolean> {
        private Method method;
        private Object target;

        private ReadyFuncAdaptor(Object target, Method method) {
            this.method = method;
            this.target = target;
        }

        @Override
        public Boolean get() {
            try {
                return (boolean)((Boolean)this.method.invoke(this.target, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("invalid ReadyFunc method signature", (Throwable)e);
                return false;
            }
        }
    }

    private static class DeleteFilterAdaptor
    implements BiPredicate {
        private Method method;
        private Object target;

        private DeleteFilterAdaptor(Object target, Method method) {
            this.method = method;
            this.target = target;
        }

        public boolean test(Object deleteObj, Object cacheStatusUnknown) {
            try {
                return (Boolean)this.method.invoke(this.target, deleteObj, cacheStatusUnknown);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("invalid EventDeleteFilter method signature", (Throwable)e);
                return true;
            }
        }
    }

    private static class UpdateFilterAdaptor
    implements BiPredicate {
        private Method method;
        private Object target;

        private UpdateFilterAdaptor(Object target, Method method) {
            this.method = method;
            this.target = target;
        }

        public boolean test(Object oldObj, Object newObj) {
            try {
                return (Boolean)this.method.invoke(this.target, oldObj, newObj);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("invalid EventUpdateFilter method signature", (Throwable)e);
                return true;
            }
        }
    }

    private static class AddFilterAdaptor
    implements Predicate {
        private Method method;
        private Object target;

        private AddFilterAdaptor(Object target, Method method) {
            this.method = method;
            this.target = target;
        }

        public boolean test(Object addedObj) {
            try {
                return (Boolean)this.method.invoke(this.target, addedObj);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("invalid EventAddFilter method signature", (Throwable)e);
                return true;
            }
        }
    }
}

