/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.aot;

import com.google.gson.annotations.JsonAdapter;
import io.kubernetes.client.extended.controller.Controller;
import io.swagger.annotations.ApiModel;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;

public class KubernetesBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesBeanFactoryInitializationAotProcessor.class);
    private final MemberCategory[] allMemberCategories = MemberCategory.values();

    public BeanFactoryInitializationAotContribution processAheadOfTime(@NotNull ConfigurableListableBeanFactory beanFactory) {
        return (generationContext, beanFactoryInitializationCode) -> {
            String[] classNames;
            RuntimeHints hints = generationContext.getRuntimeHints();
            for (String className : classNames = new String[]{"com.google.gson.JsonElement", "io.kubernetes.client.informer.cache.ProcessorListener", "io.kubernetes.client.extended.controller.Controller", "io.kubernetes.client.util.generic.GenericKubernetesApi$StatusPatch", "io.kubernetes.client.util.Watch$Response"}) {
                LOGGER.info("registering " + className + " for reflection");
                hints.reflection().registerType(TypeReference.of((String)className), this.allMemberCategories);
            }
            this.registerForPackage("io.kubernetes", hints);
            List packages = AutoConfigurationPackages.get((BeanFactory)beanFactory);
            for (String packageName : packages) {
                this.registerForPackage(packageName, hints);
            }
        };
    }

    private void registerForPackage(String packageName, RuntimeHints hints) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set apiModels = reflections.getTypesAnnotatedWith(ApiModel.class);
        Set controllers = reflections.getSubTypesOf(Controller.class);
        Set<Class<?>> jsonAdapters = this.findJsonAdapters(reflections);
        HashSet all = new HashSet();
        all.addAll(jsonAdapters);
        all.addAll(controllers);
        all.addAll(apiModels);
        for (Class clazz : all) {
            LOGGER.info("registering " + clazz.getName() + " for reflection");
            hints.reflection().registerType(clazz, this.allMemberCategories);
        }
    }

    private <R extends Annotation> Set<Class<?>> findJsonAdapters(Reflections reflections) {
        Class<JsonAdapter> jsonAdapterClass = JsonAdapter.class;
        HashSet classes = new HashSet();
        for (Class clazz : reflections.getTypesAnnotatedWith(jsonAdapterClass)) {
            JsonAdapter annotation = clazz.getAnnotation(jsonAdapterClass);
            if (null != annotation) {
                classes.add(annotation.value());
            }
            classes.add(clazz);
        }
        return classes;
    }
}

