/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.NodeMetrics;
import io.kubernetes.client.custom.PodMetrics;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.KubectlApiResources;
import io.kubernetes.client.extended.kubectl.KubectlCopy;
import io.kubernetes.client.extended.kubectl.KubectlCordon;
import io.kubernetes.client.extended.kubectl.KubectlDelete;
import io.kubernetes.client.extended.kubectl.KubectlExec;
import io.kubernetes.client.extended.kubectl.KubectlLabel;
import io.kubernetes.client.extended.kubectl.KubectlLog;
import io.kubernetes.client.extended.kubectl.KubectlPortForward;
import io.kubernetes.client.extended.kubectl.KubectlScale;
import io.kubernetes.client.extended.kubectl.KubectlTaint;
import io.kubernetes.client.extended.kubectl.KubectlTop;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.tuple.Pair;

public class KubectlExample {
    private static final String PADDING = "                              ";

    static Class<? extends KubernetesObject> getClassForKind(String kind) {
        switch (kind) {
            case "pod": 
            case "pods": {
                return V1Pod.class;
            }
            case "deployment": 
            case "deployments": {
                return V1Deployment.class;
            }
            case "service": 
            case "services": {
                return V1Service.class;
            }
            case "node": 
            case "nodes": {
                return V1Node.class;
            }
            case "replicationcontroller": 
            case "replicationcontrollers": {
                return V1ReplicationController.class;
            }
        }
        return null;
    }

    private static String pad(String value) {
        while (value.length() < PADDING.length()) {
            value = value + " ";
        }
        return value;
    }

    public static void main(String[] args) throws IOException, KubectlException, ParseException {
        ApiClient client = Config.defaultClient();
        Options options = new Options();
        options.addOption(new Option("n", "namespace", true, "The namespace for the resource"));
        options.addOption(new Option("r", "replicas", true, "The number of replicas to scale to"));
        options.addOption(new Option("c", "container", true, "The container in a pod to connect to"));
        DefaultParser parser = new DefaultParser();
        CommandLine cli = parser.parse(options, args);
        args = cli.getArgs();
        String verb = args[0];
        String ns = cli.getOptionValue("n", "default");
        String kind = null;
        String name = null;
        switch (verb) {
            case "delete": {
                kind = args[1];
                name = args[2];
                ((KubectlDelete)((KubectlDelete)Kubectl.delete(KubectlExample.getClassForKind(kind)).namespace(ns)).name(name)).execute();
            }
            case "drain": {
                name = args[1];
                ((KubectlCordon)((KubectlCordon)Kubectl.drain().apiClient(client)).name(name)).execute();
                System.out.println("Node drained");
                System.exit(0);
            }
            case "cordon": {
                name = args[1];
                ((KubectlCordon)((KubectlCordon)Kubectl.cordon().apiClient(client)).name(name)).execute();
                System.out.println("Node cordoned");
                System.exit(0);
            }
            case "uncordon": {
                name = args[1];
                ((KubectlCordon)((KubectlCordon)Kubectl.uncordon().apiClient(client)).name(name)).execute();
                System.out.println("Node uncordoned");
                System.exit(0);
            }
            case "top": {
                String what;
                switch (what = args[1]) {
                    case "nodes": 
                    case "node": {
                        List nodes = ((KubectlTop)Kubectl.top(V1Node.class, NodeMetrics.class).apiClient(client)).metric("cpu").execute();
                        System.out.println(KubectlExample.pad("Node") + "\tCPU\t\tMemory");
                        for (Pair node : nodes) {
                            System.out.println(KubectlExample.pad(((V1Node)node.getLeft()).getMetadata().getName()) + "\t" + ((Quantity)((NodeMetrics)node.getRight()).getUsage().get("cpu")).getNumber() + "\t" + ((Quantity)((NodeMetrics)node.getRight()).getUsage().get("memory")).getNumber());
                        }
                        System.exit(0);
                    }
                    case "pods": 
                    case "pod": {
                        List pods = ((KubectlTop)((KubectlTop)Kubectl.top(V1Pod.class, PodMetrics.class).apiClient(client)).namespace(ns)).metric("cpu").execute();
                        System.out.println(KubectlExample.pad("Pod") + "\tCPU\t\tMemory");
                        for (Pair pod : pods) {
                            System.out.println(KubectlExample.pad(((V1Pod)pod.getLeft()).getMetadata().getName()) + "\t" + KubectlTop.podMetricSum((PodMetrics)((PodMetrics)pod.getRight()), (String)"cpu") + "\t" + KubectlTop.podMetricSum((PodMetrics)((PodMetrics)pod.getRight()), (String)"memory"));
                        }
                        System.exit(0);
                    }
                }
                System.err.println("Unknown top argument: " + what);
                System.exit(-1);
            }
            case "cp": {
                String[] parts;
                String from = args[1];
                String to = args[2];
                if (from.indexOf(":") != -1) {
                    parts = from.split(":");
                    name = parts[0];
                    from = parts[1];
                    ((KubectlCopy)((KubectlCopy)((KubectlCopy)((KubectlCopy)Kubectl.copy().apiClient(client)).namespace(ns)).name(name)).container(cli.getOptionValue("c", ""))).fromPod(from).to(to).execute();
                } else if (to.indexOf(":") != -1) {
                    parts = to.split(":");
                    name = parts[0];
                    to = parts[1];
                    ((KubectlCopy)((KubectlCopy)((KubectlCopy)((KubectlCopy)Kubectl.copy().apiClient(client)).namespace(ns)).name(name)).container(cli.getOptionValue("c", ""))).from(from).toPod(to).execute();
                } else {
                    System.err.println("Missing pod name for copy.");
                    System.exit(-1);
                }
                System.out.println("Copied " + from + " -> " + to);
                System.exit(0);
            }
            case "taint": {
                String key;
                name = args[1];
                String taintSpec = args[2];
                boolean remove = taintSpec.endsWith("-");
                int ix = taintSpec.indexOf("=");
                int ix2 = taintSpec.indexOf(":");
                if (remove) {
                    String effect;
                    taintSpec = taintSpec.substring(0, taintSpec.length() - 2);
                    key = ix == -1 ? taintSpec : taintSpec.substring(0, ix);
                    String string = effect = ix == -1 ? null : taintSpec.substring(ix + 1);
                    if (effect == null) {
                        ((KubectlTaint)((KubectlTaint)Kubectl.taint().apiClient(client)).name(name)).removeTaint(key).execute();
                    } else {
                        ((KubectlTaint)((KubectlTaint)Kubectl.taint().apiClient(client)).name(name)).removeTaint(key, effect).execute();
                    }
                    System.exit(0);
                }
                if (ix2 == -1) {
                    System.err.println("key:effect or key=value:effect is required.");
                    System.exit(-1);
                }
                key = taintSpec.substring(0, ix == -1 ? ix2 : ix);
                String value = ix == -1 ? null : taintSpec.substring(ix + 1, ix2);
                String effect = taintSpec.substring(ix2 + 1);
                if (value == null) {
                    ((KubectlTaint)((KubectlTaint)Kubectl.taint().apiClient(client)).name(name)).addTaint(key, effect).execute();
                } else {
                    ((KubectlTaint)((KubectlTaint)Kubectl.taint().apiClient(client)).name(name)).addTaint(key, value, effect).execute();
                }
                System.exit(0);
            }
            case "portforward": {
                name = args[1];
                KubectlPortForward forward = (KubectlPortForward)((KubectlPortForward)((KubectlPortForward)Kubectl.portforward().apiClient(client)).name(name)).namespace(ns);
                for (int i = 2; i < args.length; ++i) {
                    String port = args[i];
                    String[] ports = port.split(":");
                    System.out.println("Forwarding " + ns + "/" + name + " " + ports[0] + "->" + ports[1]);
                    forward.ports(Integer.parseInt(ports[0]), Integer.parseInt(ports[1]));
                }
                forward.execute();
                System.exit(0);
            }
            case "log": {
                name = args[1];
                Streams.copy((InputStream)((KubectlLog)((KubectlLog)((KubectlLog)((KubectlLog)Kubectl.log().apiClient(client)).name(name)).namespace(ns)).container(cli.getOptionValue("c", ""))).execute(), (OutputStream)System.out);
                System.exit(0);
            }
            case "scale": {
                kind = args[1];
                name = args[2];
                if (!cli.hasOption("r")) {
                    System.err.println("--replicas <n> is required");
                    System.exit(-3);
                }
                int replicas = Integer.parseInt(cli.getOptionValue("r"));
                ((KubectlScale)((KubectlScale)((KubectlScale)Kubectl.scale(KubectlExample.getClassForKind(kind)).apiClient(client)).namespace(ns)).name(name)).replicas(replicas).execute();
                System.out.println("Deployment scaled.");
                System.exit(0);
            }
            case "version": {
                System.out.println(Kubectl.version().apiClient(client));
                System.exit(0);
            }
            case "label": {
                kind = args[1];
                name = args[2];
                String labelKey = args[3];
                String labelValue = args[4];
                Class<? extends KubernetesObject> clazz = KubectlExample.getClassForKind(kind);
                if (clazz == null) {
                    System.err.println("Unknown kind: " + kind);
                    System.exit(-2);
                }
                ((KubectlLabel)((KubectlLabel)((KubectlLabel)Kubectl.label(clazz).apiClient(client)).namespace(ns)).name(name)).addLabel(labelKey, labelValue);
                System.exit(0);
            }
            case "exec": {
                name = args[1];
                String[] command = Arrays.copyOfRange(args, 2, args.length);
                KubectlExec e = (KubectlExec)((KubectlExec)((KubectlExec)((KubectlExec)Kubectl.exec().apiClient(client)).namespace(ns)).name(name)).command(command).container(cli.getOptionValue("c", ""));
                System.exit(e.execute());
            }
            case "api-resources": {
                ((KubectlApiResources)Kubectl.apiResources().apiClient(client)).execute().stream().forEach(r -> System.out.printf("%s\t\t%s\t\t%s\t\t%s\n", r.getResourcePlural(), r.getGroup(), r.getKind(), r.getNamespaced()));
                System.exit(0);
            }
        }
        System.out.println("Unknown verb: " + verb);
        System.exit(-1);
    }
}

