/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.ControllerManager;
import io.kubernetes.client.extended.controller.LeaderElectingController;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.extended.event.EventType;
import io.kubernetes.client.extended.event.legacy.EventRecorder;
import io.kubernetes.client.extended.event.legacy.LegacyEventBroadcaster;
import io.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.kubernetes.client.extended.leaderelection.LeaderElector;
import io.kubernetes.client.extended.leaderelection.Lock;
import io.kubernetes.client.extended.leaderelection.resourcelock.EndpointsLock;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeList;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ControllerExample {
    public static void main(String[] args) throws IOException {
        CoreV1Api coreV1Api = new CoreV1Api();
        ApiClient apiClient = coreV1Api.getApiClient();
        OkHttpClient httpClient = apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build();
        apiClient.setHttpClient(httpClient);
        SharedInformerFactory informerFactory = new SharedInformerFactory();
        SharedIndexInformer nodeInformer = informerFactory.sharedIndexInformerFor(params -> coreV1Api.listNodeCall(null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Node.class, V1NodeList.class);
        informerFactory.startAllRegisteredInformers();
        LegacyEventBroadcaster eventBroadcaster = new LegacyEventBroadcaster(coreV1Api);
        NodePrintingReconciler nodeReconciler = new NodePrintingReconciler((SharedIndexInformer<V1Node>)nodeInformer, eventBroadcaster.newRecorder(new V1EventSource().host("localhost").component("node-printer")));
        Controller controller = ControllerBuilder.defaultBuilder((SharedInformerFactory)informerFactory).watch(workQueue -> ControllerBuilder.controllerWatchBuilder(V1Node.class, (WorkQueue)workQueue).withWorkQueueKeyFunc(node -> new Request(node.getMetadata().getName())).withOnAddFilter(createdNode -> createdNode.getMetadata().getName().startsWith("docker-")).withOnUpdateFilter((oldNode, newNode) -> newNode.getMetadata().getName().startsWith("docker-")).withOnDeleteFilter((deletedNode, stateUnknown) -> deletedNode.getMetadata().getName().startsWith("docker-")).build()).withReconciler((Reconciler)nodeReconciler).withName("node-printing-controller").withWorkerCount(4).withReadyFunc(() -> ((SharedIndexInformer)nodeInformer).hasSynced()).build();
        ControllerManager controllerManager = ControllerBuilder.controllerManagerBuilder((SharedInformerFactory)informerFactory).addController(controller).build();
        LeaderElectingController leaderElectingController = new LeaderElectingController(new LeaderElector(new LeaderElectionConfig((Lock)new EndpointsLock("kube-system", "leader-election", "foo"), Duration.ofMillis(10000L), Duration.ofMillis(8000L), Duration.ofMillis(5000L))), (Controller)controllerManager);
        leaderElectingController.run();
    }

    static class NodePrintingReconciler
    implements Reconciler {
        private Lister<V1Node> nodeLister;
        private EventRecorder eventRecorder;

        public NodePrintingReconciler(SharedIndexInformer<V1Node> nodeInformer, EventRecorder recorder) {
            this.nodeLister = new Lister(nodeInformer.getIndexer());
            this.eventRecorder = recorder;
        }

        public Result reconcile(Request request) {
            V1Node node = (V1Node)this.nodeLister.get(request.getName());
            System.out.println("triggered reconciling " + node.getMetadata().getName());
            this.eventRecorder.event((KubernetesObject)node, EventType.Normal, "Print Node", "Successfully printed %s", new String[]{node.getMetadata().getName()});
            return new Result(false);
        }
    }
}

