/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.builder.DefaultControllerBuilder;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@SpringBootApplication
public class SpringControllerExample {
    public static void main(String[] args) {
        SpringApplication.run(SpringControllerExample.class, (String[])args);
    }

    @Component
    public static class NodePrintingReconciler
    implements Reconciler {
        @Value(value="${namespace}")
        private String namespace;
        private SharedInformer<V1Node> nodeInformer;
        private SharedInformer<V1Pod> podInformer;
        private Lister<V1Node> nodeLister;
        private Lister<V1Pod> podLister;

        public NodePrintingReconciler(SharedIndexInformer<V1Node> nodeInformer, SharedIndexInformer<V1Pod> podInformer) {
            this.nodeInformer = nodeInformer;
            this.podInformer = podInformer;
            this.nodeLister = new Lister(nodeInformer.getIndexer(), this.namespace);
            this.podLister = new Lister(podInformer.getIndexer(), this.namespace);
        }

        public boolean informerReady() {
            return this.podInformer.hasSynced() && this.nodeInformer.hasSynced();
        }

        public Result reconcile(Request request) {
            V1Node node = (V1Node)this.nodeLister.get(request.getName());
            System.out.println("get all pods in namespace " + this.namespace);
            this.podLister.namespace(this.namespace).list().stream().map(pod -> pod.getMetadata().getName()).forEach(System.out::println);
            System.out.println("triggered reconciling " + node.getMetadata().getName());
            return new Result(false);
        }
    }

    @Configuration
    public static class AppConfig {
        @Bean
        public CommandLineRunner commandLineRunner(SharedInformerFactory sharedInformerFactory, Controller nodePrintingController) {
            return args -> {
                System.out.println("starting informers..");
                sharedInformerFactory.startAllRegisteredInformers();
                System.out.println("running controller..");
                nodePrintingController.run();
            };
        }

        @Bean
        public Controller nodePrintingController(SharedInformerFactory sharedInformerFactory, NodePrintingReconciler reconciler) {
            DefaultControllerBuilder builder = ControllerBuilder.defaultBuilder((SharedInformerFactory)sharedInformerFactory);
            builder = builder.watch(q -> ControllerBuilder.controllerWatchBuilder(V1Node.class, (WorkQueue)q).withResyncPeriod(Duration.ofMinutes(1L)).build());
            builder.withWorkerCount(2);
            builder.withReadyFunc(reconciler::informerReady);
            return builder.withReconciler((Reconciler)reconciler).withName("nodePrintingController").build();
        }

        @Bean
        public SharedIndexInformer<V1Endpoints> endpointsInformer(ApiClient apiClient, SharedInformerFactory sharedInformerFactory) {
            GenericKubernetesApi genericApi = new GenericKubernetesApi(V1Endpoints.class, V1EndpointsList.class, "", "v1", "endpoints", apiClient);
            return sharedInformerFactory.sharedIndexInformerFor(genericApi, V1Endpoints.class, 0L);
        }

        @Bean
        public SharedIndexInformer<V1Node> nodeInformer(ApiClient apiClient, SharedInformerFactory sharedInformerFactory) {
            GenericKubernetesApi genericApi = new GenericKubernetesApi(V1Node.class, V1NodeList.class, "", "v1", "nodes", apiClient);
            return sharedInformerFactory.sharedIndexInformerFor(genericApi, V1Node.class, 60000L);
        }

        @Bean
        public SharedIndexInformer<V1Pod> podInformer(ApiClient apiClient, SharedInformerFactory sharedInformerFactory) {
            GenericKubernetesApi genericApi = new GenericKubernetesApi(V1Pod.class, V1PodList.class, "", "v1", "pods", apiClient);
            return sharedInformerFactory.sharedIndexInformerFor(genericApi, V1Pod.class, 0L);
        }
    }
}

