/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.PortForward;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

public class PortForwardExample {
    public static void main(String[] args) throws IOException, ApiException, InterruptedException {
        ApiClient client = Config.defaultClient();
        Configuration.setDefaultApiClient((ApiClient)client);
        PortForward forward = new PortForward();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        int localPort = 8080;
        final int targetPort = 8080;
        ports.add(targetPort);
        final PortForward.PortForwardResult result = forward.forward("default", "camera-viz-7949dbf7c6-lpxkd", ports);
        System.out.println("Forwarding!");
        ServerSocket ss = new ServerSocket(localPort);
        final Socket s = ss.accept();
        System.out.println("Connected!");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Streams.copy((InputStream)result.getInputStream(targetPort), (OutputStream)s.getOutputStream());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Streams.copy((InputStream)s.getInputStream(), (OutputStream)result.getOutboundStream(targetPort));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
        Thread.sleep(10000L);
        System.exit(0);
    }
}

