/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.kubernetes.client.extended.leaderelection.LeaderElector;
import io.kubernetes.client.extended.leaderelection.Lock;
import io.kubernetes.client.extended.leaderelection.resourcelock.EndpointsLock;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.Config;
import java.time.Duration;
import java.util.UUID;

public class LeaderElectionExample {
    public static void main(String[] args) throws Exception {
        ApiClient client = Config.defaultClient();
        Configuration.setDefaultApiClient((ApiClient)client);
        String appNamespace = "default";
        String appName = "leader-election-foobar";
        String lockHolderIdentityName = UUID.randomUUID().toString();
        EndpointsLock lock = new EndpointsLock(appNamespace, appName, lockHolderIdentityName);
        LeaderElectionConfig leaderElectionConfig = new LeaderElectionConfig((Lock)lock, Duration.ofMillis(10000L), Duration.ofMillis(8000L), Duration.ofMillis(2000L));
        try (LeaderElector leaderElector = new LeaderElector(leaderElectionConfig);){
            leaderElector.run(() -> System.out.println("Do something when getting leadership."), () -> System.out.println("Do something when losing leadership."));
        }
    }
}

