/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1alpha3ResourceClaimSchedulingStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha3ResourceClaimSchedulingStatusFluent<A extends V1alpha3ResourceClaimSchedulingStatusFluent<A>>
extends BaseFluent<A> {
    private String name;
    private List<String> unsuitableNodes;

    public V1alpha3ResourceClaimSchedulingStatusFluent() {
    }

    public V1alpha3ResourceClaimSchedulingStatusFluent(V1alpha3ResourceClaimSchedulingStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha3ResourceClaimSchedulingStatus instance) {
        V1alpha3ResourceClaimSchedulingStatus v1alpha3ResourceClaimSchedulingStatus = instance = instance != null ? instance : new V1alpha3ResourceClaimSchedulingStatus();
        if (instance != null) {
            this.withName(instance.getName());
            this.withUnsuitableNodes(instance.getUnsuitableNodes());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToUnsuitableNodes(int index, String item) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.add(index, item);
        return (A)this;
    }

    public A setToUnsuitableNodes(int index, String item) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.set(index, item);
        return (A)this;
    }

    public A addToUnsuitableNodes(String ... items) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.unsuitableNodes.add(item);
        }
        return (A)this;
    }

    public A addAllToUnsuitableNodes(Collection<String> items) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.unsuitableNodes.add(item);
        }
        return (A)this;
    }

    public A removeFromUnsuitableNodes(String ... items) {
        if (this.unsuitableNodes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.unsuitableNodes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromUnsuitableNodes(Collection<String> items) {
        if (this.unsuitableNodes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.unsuitableNodes.remove(item);
        }
        return (A)this;
    }

    public List<String> getUnsuitableNodes() {
        return this.unsuitableNodes;
    }

    public String getUnsuitableNode(int index) {
        return this.unsuitableNodes.get(index);
    }

    public String getFirstUnsuitableNode() {
        return this.unsuitableNodes.get(0);
    }

    public String getLastUnsuitableNode() {
        return this.unsuitableNodes.get(this.unsuitableNodes.size() - 1);
    }

    public String getMatchingUnsuitableNode(Predicate<String> predicate) {
        for (String item : this.unsuitableNodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUnsuitableNode(Predicate<String> predicate) {
        for (String item : this.unsuitableNodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUnsuitableNodes(List<String> unsuitableNodes) {
        if (unsuitableNodes != null) {
            this.unsuitableNodes = new ArrayList<String>();
            for (String item : unsuitableNodes) {
                this.addToUnsuitableNodes(item);
            }
        } else {
            this.unsuitableNodes = null;
        }
        return (A)this;
    }

    public A withUnsuitableNodes(String ... unsuitableNodes) {
        if (this.unsuitableNodes != null) {
            this.unsuitableNodes.clear();
            this._visitables.remove("unsuitableNodes");
        }
        if (unsuitableNodes != null) {
            for (String item : unsuitableNodes) {
                this.addToUnsuitableNodes(item);
            }
        }
        return (A)this;
    }

    public boolean hasUnsuitableNodes() {
        return this.unsuitableNodes != null && !this.unsuitableNodes.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha3ResourceClaimSchedulingStatusFluent that = (V1alpha3ResourceClaimSchedulingStatusFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.unsuitableNodes, that.unsuitableNodes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.unsuitableNodes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.unsuitableNodes != null && !this.unsuitableNodes.isEmpty()) {
            sb.append("unsuitableNodes:");
            sb.append(this.unsuitableNodes);
        }
        sb.append("}");
        return sb.toString();
    }
}

