/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1alpha3PodSchedulingContextSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha3PodSchedulingContextSpecFluent<A extends V1alpha3PodSchedulingContextSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> potentialNodes;
    private String selectedNode;

    public V1alpha3PodSchedulingContextSpecFluent() {
    }

    public V1alpha3PodSchedulingContextSpecFluent(V1alpha3PodSchedulingContextSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha3PodSchedulingContextSpec instance) {
        V1alpha3PodSchedulingContextSpec v1alpha3PodSchedulingContextSpec = instance = instance != null ? instance : new V1alpha3PodSchedulingContextSpec();
        if (instance != null) {
            this.withPotentialNodes(instance.getPotentialNodes());
            this.withSelectedNode(instance.getSelectedNode());
        }
    }

    public A addToPotentialNodes(int index, String item) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.add(index, item);
        return (A)this;
    }

    public A setToPotentialNodes(int index, String item) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.set(index, item);
        return (A)this;
    }

    public A addToPotentialNodes(String ... items) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.potentialNodes.add(item);
        }
        return (A)this;
    }

    public A addAllToPotentialNodes(Collection<String> items) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.potentialNodes.add(item);
        }
        return (A)this;
    }

    public A removeFromPotentialNodes(String ... items) {
        if (this.potentialNodes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.potentialNodes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPotentialNodes(Collection<String> items) {
        if (this.potentialNodes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.potentialNodes.remove(item);
        }
        return (A)this;
    }

    public List<String> getPotentialNodes() {
        return this.potentialNodes;
    }

    public String getPotentialNode(int index) {
        return this.potentialNodes.get(index);
    }

    public String getFirstPotentialNode() {
        return this.potentialNodes.get(0);
    }

    public String getLastPotentialNode() {
        return this.potentialNodes.get(this.potentialNodes.size() - 1);
    }

    public String getMatchingPotentialNode(Predicate<String> predicate) {
        for (String item : this.potentialNodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPotentialNode(Predicate<String> predicate) {
        for (String item : this.potentialNodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPotentialNodes(List<String> potentialNodes) {
        if (potentialNodes != null) {
            this.potentialNodes = new ArrayList<String>();
            for (String item : potentialNodes) {
                this.addToPotentialNodes(item);
            }
        } else {
            this.potentialNodes = null;
        }
        return (A)this;
    }

    public A withPotentialNodes(String ... potentialNodes) {
        if (this.potentialNodes != null) {
            this.potentialNodes.clear();
            this._visitables.remove("potentialNodes");
        }
        if (potentialNodes != null) {
            for (String item : potentialNodes) {
                this.addToPotentialNodes(item);
            }
        }
        return (A)this;
    }

    public boolean hasPotentialNodes() {
        return this.potentialNodes != null && !this.potentialNodes.isEmpty();
    }

    public String getSelectedNode() {
        return this.selectedNode;
    }

    public A withSelectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
        return (A)this;
    }

    public boolean hasSelectedNode() {
        return this.selectedNode != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha3PodSchedulingContextSpecFluent that = (V1alpha3PodSchedulingContextSpecFluent)o;
        if (!Objects.equals(this.potentialNodes, that.potentialNodes)) {
            return false;
        }
        return Objects.equals(this.selectedNode, that.selectedNode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.potentialNodes, this.selectedNode, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.potentialNodes != null && !this.potentialNodes.isEmpty()) {
            sb.append("potentialNodes:");
            sb.append(this.potentialNodes + ",");
        }
        if (this.selectedNode != null) {
            sb.append("selectedNode:");
            sb.append(this.selectedNode);
        }
        sb.append("}");
        return sb.toString();
    }
}

