/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1alpha3BasicDevice;
import io.kubernetes.client.openapi.models.V1alpha3DeviceAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class V1alpha3BasicDeviceFluent<A extends V1alpha3BasicDeviceFluent<A>>
extends BaseFluent<A> {
    private Map<String, V1alpha3DeviceAttribute> attributes;
    private Map<String, Quantity> capacity;

    public V1alpha3BasicDeviceFluent() {
    }

    public V1alpha3BasicDeviceFluent(V1alpha3BasicDevice instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha3BasicDevice instance) {
        V1alpha3BasicDevice v1alpha3BasicDevice = instance = instance != null ? instance : new V1alpha3BasicDevice();
        if (instance != null) {
            this.withAttributes(instance.getAttributes());
            this.withCapacity(instance.getCapacity());
        }
    }

    public A addToAttributes(String key, V1alpha3DeviceAttribute value) {
        if (this.attributes == null && key != null && value != null) {
            this.attributes = new LinkedHashMap<String, V1alpha3DeviceAttribute>();
        }
        if (key != null && value != null) {
            this.attributes.put(key, value);
        }
        return (A)this;
    }

    public A addToAttributes(Map<String, V1alpha3DeviceAttribute> map) {
        if (this.attributes == null && map != null) {
            this.attributes = new LinkedHashMap<String, V1alpha3DeviceAttribute>();
        }
        if (map != null) {
            this.attributes.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAttributes(String key) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (key != null && this.attributes != null) {
            this.attributes.remove(key);
        }
        return (A)this;
    }

    public A removeFromAttributes(Map<String, V1alpha3DeviceAttribute> map) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.attributes == null) continue;
                this.attributes.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, V1alpha3DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    public <K, V> A withAttributes(Map<String, V1alpha3DeviceAttribute> attributes) {
        this.attributes = attributes == null ? null : new LinkedHashMap<String, V1alpha3DeviceAttribute>(attributes);
        return (A)this;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public A addToCapacity(String key, Quantity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    public A addToCapacity(Map<String, Quantity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    public A removeFromCapacity(Map<String, Quantity> map) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public <K, V> A withCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, Quantity>(capacity);
        return (A)this;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha3BasicDeviceFluent that = (V1alpha3BasicDeviceFluent)o;
        if (!Objects.equals(this.attributes, that.attributes)) {
            return false;
        }
        return Objects.equals(this.capacity, that.capacity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attributes, this.capacity, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append("attributes:");
            sb.append(this.attributes + ",");
        }
        if (this.capacity != null && !this.capacity.isEmpty()) {
            sb.append("capacity:");
            sb.append(this.capacity);
        }
        sb.append("}");
        return sb.toString();
    }
}

