/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1alpha1LeaseCandidateSpec;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha1LeaseCandidateSpecFluent<A extends V1alpha1LeaseCandidateSpecFluent<A>>
extends BaseFluent<A> {
    private String binaryVersion;
    private String emulationVersion;
    private String leaseName;
    private OffsetDateTime pingTime;
    private List<String> preferredStrategies;
    private OffsetDateTime renewTime;

    public V1alpha1LeaseCandidateSpecFluent() {
    }

    public V1alpha1LeaseCandidateSpecFluent(V1alpha1LeaseCandidateSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha1LeaseCandidateSpec instance) {
        V1alpha1LeaseCandidateSpec v1alpha1LeaseCandidateSpec = instance = instance != null ? instance : new V1alpha1LeaseCandidateSpec();
        if (instance != null) {
            this.withBinaryVersion(instance.getBinaryVersion());
            this.withEmulationVersion(instance.getEmulationVersion());
            this.withLeaseName(instance.getLeaseName());
            this.withPingTime(instance.getPingTime());
            this.withPreferredStrategies(instance.getPreferredStrategies());
            this.withRenewTime(instance.getRenewTime());
        }
    }

    public String getBinaryVersion() {
        return this.binaryVersion;
    }

    public A withBinaryVersion(String binaryVersion) {
        this.binaryVersion = binaryVersion;
        return (A)this;
    }

    public boolean hasBinaryVersion() {
        return this.binaryVersion != null;
    }

    public String getEmulationVersion() {
        return this.emulationVersion;
    }

    public A withEmulationVersion(String emulationVersion) {
        this.emulationVersion = emulationVersion;
        return (A)this;
    }

    public boolean hasEmulationVersion() {
        return this.emulationVersion != null;
    }

    public String getLeaseName() {
        return this.leaseName;
    }

    public A withLeaseName(String leaseName) {
        this.leaseName = leaseName;
        return (A)this;
    }

    public boolean hasLeaseName() {
        return this.leaseName != null;
    }

    public OffsetDateTime getPingTime() {
        return this.pingTime;
    }

    public A withPingTime(OffsetDateTime pingTime) {
        this.pingTime = pingTime;
        return (A)this;
    }

    public boolean hasPingTime() {
        return this.pingTime != null;
    }

    public A addToPreferredStrategies(int index, String item) {
        if (this.preferredStrategies == null) {
            this.preferredStrategies = new ArrayList<String>();
        }
        this.preferredStrategies.add(index, item);
        return (A)this;
    }

    public A setToPreferredStrategies(int index, String item) {
        if (this.preferredStrategies == null) {
            this.preferredStrategies = new ArrayList<String>();
        }
        this.preferredStrategies.set(index, item);
        return (A)this;
    }

    public A addToPreferredStrategies(String ... items) {
        if (this.preferredStrategies == null) {
            this.preferredStrategies = new ArrayList<String>();
        }
        for (String item : items) {
            this.preferredStrategies.add(item);
        }
        return (A)this;
    }

    public A addAllToPreferredStrategies(Collection<String> items) {
        if (this.preferredStrategies == null) {
            this.preferredStrategies = new ArrayList<String>();
        }
        for (String item : items) {
            this.preferredStrategies.add(item);
        }
        return (A)this;
    }

    public A removeFromPreferredStrategies(String ... items) {
        if (this.preferredStrategies == null) {
            return (A)this;
        }
        for (String item : items) {
            this.preferredStrategies.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPreferredStrategies(Collection<String> items) {
        if (this.preferredStrategies == null) {
            return (A)this;
        }
        for (String item : items) {
            this.preferredStrategies.remove(item);
        }
        return (A)this;
    }

    public List<String> getPreferredStrategies() {
        return this.preferredStrategies;
    }

    public String getPreferredStrategy(int index) {
        return this.preferredStrategies.get(index);
    }

    public String getFirstPreferredStrategy() {
        return this.preferredStrategies.get(0);
    }

    public String getLastPreferredStrategy() {
        return this.preferredStrategies.get(this.preferredStrategies.size() - 1);
    }

    public String getMatchingPreferredStrategy(Predicate<String> predicate) {
        for (String item : this.preferredStrategies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPreferredStrategy(Predicate<String> predicate) {
        for (String item : this.preferredStrategies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPreferredStrategies(List<String> preferredStrategies) {
        if (preferredStrategies != null) {
            this.preferredStrategies = new ArrayList<String>();
            for (String item : preferredStrategies) {
                this.addToPreferredStrategies(item);
            }
        } else {
            this.preferredStrategies = null;
        }
        return (A)this;
    }

    public A withPreferredStrategies(String ... preferredStrategies) {
        if (this.preferredStrategies != null) {
            this.preferredStrategies.clear();
            this._visitables.remove("preferredStrategies");
        }
        if (preferredStrategies != null) {
            for (String item : preferredStrategies) {
                this.addToPreferredStrategies(item);
            }
        }
        return (A)this;
    }

    public boolean hasPreferredStrategies() {
        return this.preferredStrategies != null && !this.preferredStrategies.isEmpty();
    }

    public OffsetDateTime getRenewTime() {
        return this.renewTime;
    }

    public A withRenewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
        return (A)this;
    }

    public boolean hasRenewTime() {
        return this.renewTime != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1LeaseCandidateSpecFluent that = (V1alpha1LeaseCandidateSpecFluent)o;
        if (!Objects.equals(this.binaryVersion, that.binaryVersion)) {
            return false;
        }
        if (!Objects.equals(this.emulationVersion, that.emulationVersion)) {
            return false;
        }
        if (!Objects.equals(this.leaseName, that.leaseName)) {
            return false;
        }
        if (!Objects.equals(this.pingTime, that.pingTime)) {
            return false;
        }
        if (!Objects.equals(this.preferredStrategies, that.preferredStrategies)) {
            return false;
        }
        return Objects.equals(this.renewTime, that.renewTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.binaryVersion, this.emulationVersion, this.leaseName, this.pingTime, this.preferredStrategies, this.renewTime, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.binaryVersion != null) {
            sb.append("binaryVersion:");
            sb.append(this.binaryVersion + ",");
        }
        if (this.emulationVersion != null) {
            sb.append("emulationVersion:");
            sb.append(this.emulationVersion + ",");
        }
        if (this.leaseName != null) {
            sb.append("leaseName:");
            sb.append(this.leaseName + ",");
        }
        if (this.pingTime != null) {
            sb.append("pingTime:");
            sb.append(this.pingTime + ",");
        }
        if (this.preferredStrategies != null && !this.preferredStrategies.isEmpty()) {
            sb.append("preferredStrategies:");
            sb.append(this.preferredStrategies + ",");
        }
        if (this.renewTime != null) {
            sb.append("renewTime:");
            sb.append(this.renewTime);
        }
        sb.append("}");
        return sb.toString();
    }
}

