/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodResourceClaim references exactly one ResourceClaim, either directly or by naming a ResourceClaimTemplate which is then turned into a ResourceClaim for the pod.  It adds a name to it that uniquely identifies the ResourceClaim inside the Pod. Containers that need access to the ResourceClaim reference it with this name.")
public class V1PodResourceClaim {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_NAME = "resourceClaimName";
    @SerializedName(value="resourceClaimName")
    private String resourceClaimName;
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_TEMPLATE_NAME = "resourceClaimTemplateName";
    @SerializedName(value="resourceClaimTemplateName")
    private String resourceClaimTemplateName;

    public V1PodResourceClaim name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name uniquely identifies this resource claim inside the pod. This must be a DNS_LABEL.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1PodResourceClaim resourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.  Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.")
    public String getResourceClaimName() {
        return this.resourceClaimName;
    }

    public void setResourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
    }

    public V1PodResourceClaim resourceClaimTemplateName(String resourceClaimTemplateName) {
        this.resourceClaimTemplateName = resourceClaimTemplateName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.  The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.  This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.  Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.")
    public String getResourceClaimTemplateName() {
        return this.resourceClaimTemplateName;
    }

    public void setResourceClaimTemplateName(String resourceClaimTemplateName) {
        this.resourceClaimTemplateName = resourceClaimTemplateName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodResourceClaim v1PodResourceClaim = (V1PodResourceClaim)o;
        return Objects.equals(this.name, v1PodResourceClaim.name) && Objects.equals(this.resourceClaimName, v1PodResourceClaim.resourceClaimName) && Objects.equals(this.resourceClaimTemplateName, v1PodResourceClaim.resourceClaimTemplateName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resourceClaimName, this.resourceClaimTemplateName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodResourceClaim {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resourceClaimName: ").append(this.toIndentedString(this.resourceClaimName)).append("\n");
        sb.append("    resourceClaimTemplateName: ").append(this.toIndentedString(this.resourceClaimTemplateName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

