/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1beta3NonResourcePolicyRule;
import io.kubernetes.client.openapi.models.V1beta3NonResourcePolicyRuleBuilder;
import io.kubernetes.client.openapi.models.V1beta3NonResourcePolicyRuleFluent;
import io.kubernetes.client.openapi.models.V1beta3PolicyRulesWithSubjects;
import io.kubernetes.client.openapi.models.V1beta3ResourcePolicyRule;
import io.kubernetes.client.openapi.models.V1beta3ResourcePolicyRuleBuilder;
import io.kubernetes.client.openapi.models.V1beta3ResourcePolicyRuleFluent;
import io.kubernetes.client.openapi.models.V1beta3Subject;
import io.kubernetes.client.openapi.models.V1beta3SubjectBuilder;
import io.kubernetes.client.openapi.models.V1beta3SubjectFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1beta3PolicyRulesWithSubjectsFluent<A extends V1beta3PolicyRulesWithSubjectsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1beta3NonResourcePolicyRuleBuilder> nonResourceRules;
    private ArrayList<V1beta3ResourcePolicyRuleBuilder> resourceRules;
    private ArrayList<V1beta3SubjectBuilder> subjects;

    public V1beta3PolicyRulesWithSubjectsFluent() {
    }

    public V1beta3PolicyRulesWithSubjectsFluent(V1beta3PolicyRulesWithSubjects instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta3PolicyRulesWithSubjects instance) {
        V1beta3PolicyRulesWithSubjects v1beta3PolicyRulesWithSubjects = instance = instance != null ? instance : new V1beta3PolicyRulesWithSubjects();
        if (instance != null) {
            this.withNonResourceRules(instance.getNonResourceRules());
            this.withResourceRules(instance.getResourceRules());
            this.withSubjects(instance.getSubjects());
        }
    }

    public A addToNonResourceRules(int index, V1beta3NonResourcePolicyRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        V1beta3NonResourcePolicyRuleBuilder builder = new V1beta3NonResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").add(index, builder);
            this.nonResourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToNonResourceRules(int index, V1beta3NonResourcePolicyRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        V1beta3NonResourcePolicyRuleBuilder builder = new V1beta3NonResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").set(index, builder);
            this.nonResourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToNonResourceRules(V1beta3NonResourcePolicyRule ... items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (V1beta3NonResourcePolicyRule item : items) {
            V1beta3NonResourcePolicyRuleBuilder builder = new V1beta3NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToNonResourceRules(Collection<V1beta3NonResourcePolicyRule> items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (V1beta3NonResourcePolicyRule item : items) {
            V1beta3NonResourcePolicyRuleBuilder builder = new V1beta3NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromNonResourceRules(V1beta3NonResourcePolicyRule ... items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (V1beta3NonResourcePolicyRule item : items) {
            V1beta3NonResourcePolicyRuleBuilder builder = new V1beta3NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNonResourceRules(Collection<V1beta3NonResourcePolicyRule> items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (V1beta3NonResourcePolicyRule item : items) {
            V1beta3NonResourcePolicyRuleBuilder builder = new V1beta3NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNonResourceRules(Predicate<V1beta3NonResourcePolicyRuleBuilder> predicate) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        Iterator<V1beta3NonResourcePolicyRuleBuilder> each = this.nonResourceRules.iterator();
        Object visitables = this._visitables.get("nonResourceRules");
        while (each.hasNext()) {
            V1beta3NonResourcePolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta3NonResourcePolicyRule> buildNonResourceRules() {
        return this.nonResourceRules != null ? V1beta3PolicyRulesWithSubjectsFluent.build(this.nonResourceRules) : null;
    }

    public V1beta3NonResourcePolicyRule buildNonResourceRule(int index) {
        return this.nonResourceRules.get(index).build();
    }

    public V1beta3NonResourcePolicyRule buildFirstNonResourceRule() {
        return this.nonResourceRules.get(0).build();
    }

    public V1beta3NonResourcePolicyRule buildLastNonResourceRule() {
        return this.nonResourceRules.get(this.nonResourceRules.size() - 1).build();
    }

    public V1beta3NonResourcePolicyRule buildMatchingNonResourceRule(Predicate<V1beta3NonResourcePolicyRuleBuilder> predicate) {
        for (V1beta3NonResourcePolicyRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNonResourceRule(Predicate<V1beta3NonResourcePolicyRuleBuilder> predicate) {
        for (V1beta3NonResourcePolicyRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNonResourceRules(List<V1beta3NonResourcePolicyRule> nonResourceRules) {
        if (this.nonResourceRules != null) {
            this._visitables.get("nonResourceRules").clear();
        }
        if (nonResourceRules != null) {
            this.nonResourceRules = new ArrayList();
            for (V1beta3NonResourcePolicyRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        } else {
            this.nonResourceRules = null;
        }
        return (A)this;
    }

    public A withNonResourceRules(V1beta3NonResourcePolicyRule ... nonResourceRules) {
        if (this.nonResourceRules != null) {
            this.nonResourceRules.clear();
            this._visitables.remove("nonResourceRules");
        }
        if (nonResourceRules != null) {
            for (V1beta3NonResourcePolicyRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasNonResourceRules() {
        return this.nonResourceRules != null && !this.nonResourceRules.isEmpty();
    }

    public NonResourceRulesNested<A> addNewNonResourceRule() {
        return new NonResourceRulesNested(-1, null);
    }

    public NonResourceRulesNested<A> addNewNonResourceRuleLike(V1beta3NonResourcePolicyRule item) {
        return new NonResourceRulesNested(-1, item);
    }

    public NonResourceRulesNested<A> setNewNonResourceRuleLike(int index, V1beta3NonResourcePolicyRule item) {
        return new NonResourceRulesNested(index, item);
    }

    public NonResourceRulesNested<A> editNonResourceRule(int index) {
        if (this.nonResourceRules.size() <= index) {
            throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editFirstNonResourceRule() {
        if (this.nonResourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(0, this.buildNonResourceRule(0));
    }

    public NonResourceRulesNested<A> editLastNonResourceRule() {
        int index = this.nonResourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editMatchingNonResourceRule(Predicate<V1beta3NonResourcePolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nonResourceRules.size(); ++i) {
            if (!predicate.test(this.nonResourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public A addToResourceRules(int index, V1beta3ResourcePolicyRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        V1beta3ResourcePolicyRuleBuilder builder = new V1beta3ResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").add(index, builder);
            this.resourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceRules(int index, V1beta3ResourcePolicyRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        V1beta3ResourcePolicyRuleBuilder builder = new V1beta3ResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").set(index, builder);
            this.resourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceRules(V1beta3ResourcePolicyRule ... items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (V1beta3ResourcePolicyRule item : items) {
            V1beta3ResourcePolicyRuleBuilder builder = new V1beta3ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceRules(Collection<V1beta3ResourcePolicyRule> items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (V1beta3ResourcePolicyRule item : items) {
            V1beta3ResourcePolicyRuleBuilder builder = new V1beta3ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceRules(V1beta3ResourcePolicyRule ... items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (V1beta3ResourcePolicyRule item : items) {
            V1beta3ResourcePolicyRuleBuilder builder = new V1beta3ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceRules(Collection<V1beta3ResourcePolicyRule> items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (V1beta3ResourcePolicyRule item : items) {
            V1beta3ResourcePolicyRuleBuilder builder = new V1beta3ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceRules(Predicate<V1beta3ResourcePolicyRuleBuilder> predicate) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        Iterator<V1beta3ResourcePolicyRuleBuilder> each = this.resourceRules.iterator();
        Object visitables = this._visitables.get("resourceRules");
        while (each.hasNext()) {
            V1beta3ResourcePolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta3ResourcePolicyRule> buildResourceRules() {
        return this.resourceRules != null ? V1beta3PolicyRulesWithSubjectsFluent.build(this.resourceRules) : null;
    }

    public V1beta3ResourcePolicyRule buildResourceRule(int index) {
        return this.resourceRules.get(index).build();
    }

    public V1beta3ResourcePolicyRule buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    public V1beta3ResourcePolicyRule buildLastResourceRule() {
        return this.resourceRules.get(this.resourceRules.size() - 1).build();
    }

    public V1beta3ResourcePolicyRule buildMatchingResourceRule(Predicate<V1beta3ResourcePolicyRuleBuilder> predicate) {
        for (V1beta3ResourcePolicyRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceRule(Predicate<V1beta3ResourcePolicyRuleBuilder> predicate) {
        for (V1beta3ResourcePolicyRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceRules(List<V1beta3ResourcePolicyRule> resourceRules) {
        if (this.resourceRules != null) {
            this._visitables.get("resourceRules").clear();
        }
        if (resourceRules != null) {
            this.resourceRules = new ArrayList();
            for (V1beta3ResourcePolicyRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        } else {
            this.resourceRules = null;
        }
        return (A)this;
    }

    public A withResourceRules(V1beta3ResourcePolicyRule ... resourceRules) {
        if (this.resourceRules != null) {
            this.resourceRules.clear();
            this._visitables.remove("resourceRules");
        }
        if (resourceRules != null) {
            for (V1beta3ResourcePolicyRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceRules() {
        return this.resourceRules != null && !this.resourceRules.isEmpty();
    }

    public ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNested(-1, null);
    }

    public ResourceRulesNested<A> addNewResourceRuleLike(V1beta3ResourcePolicyRule item) {
        return new ResourceRulesNested(-1, item);
    }

    public ResourceRulesNested<A> setNewResourceRuleLike(int index, V1beta3ResourcePolicyRule item) {
        return new ResourceRulesNested(index, item);
    }

    public ResourceRulesNested<A> editResourceRule(int index) {
        if (this.resourceRules.size() <= index) {
            throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editFirstResourceRule() {
        if (this.resourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(0, this.buildResourceRule(0));
    }

    public ResourceRulesNested<A> editLastResourceRule() {
        int index = this.resourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editMatchingResourceRule(Predicate<V1beta3ResourcePolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceRules.size(); ++i) {
            if (!predicate.test(this.resourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public A addToSubjects(int index, V1beta3Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        V1beta3SubjectBuilder builder = new V1beta3SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").add(index, builder);
            this.subjects.add(index, builder);
        }
        return (A)this;
    }

    public A setToSubjects(int index, V1beta3Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        V1beta3SubjectBuilder builder = new V1beta3SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").set(index, builder);
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    public A addToSubjects(V1beta3Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (V1beta3Subject item : items) {
            V1beta3SubjectBuilder builder = new V1beta3SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A addAllToSubjects(Collection<V1beta3Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (V1beta3Subject item : items) {
            V1beta3SubjectBuilder builder = new V1beta3SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A removeFromSubjects(V1beta3Subject ... items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (V1beta3Subject item : items) {
            V1beta3SubjectBuilder builder = new V1beta3SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSubjects(Collection<V1beta3Subject> items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (V1beta3Subject item : items) {
            V1beta3SubjectBuilder builder = new V1beta3SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSubjects(Predicate<V1beta3SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<V1beta3SubjectBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            V1beta3SubjectBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta3Subject> buildSubjects() {
        return this.subjects != null ? V1beta3PolicyRulesWithSubjectsFluent.build(this.subjects) : null;
    }

    public V1beta3Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    public V1beta3Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    public V1beta3Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    public V1beta3Subject buildMatchingSubject(Predicate<V1beta3SubjectBuilder> predicate) {
        for (V1beta3SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubject(Predicate<V1beta3SubjectBuilder> predicate) {
        for (V1beta3SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjects(List<V1beta3Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").clear();
        }
        if (subjects != null) {
            this.subjects = new ArrayList();
            for (V1beta3Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    public A withSubjects(V1beta3Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
            this._visitables.remove("subjects");
        }
        if (subjects != null) {
            for (V1beta3Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    public SubjectsNested<A> addNewSubject() {
        return new SubjectsNested(-1, null);
    }

    public SubjectsNested<A> addNewSubjectLike(V1beta3Subject item) {
        return new SubjectsNested(-1, item);
    }

    public SubjectsNested<A> setNewSubjectLike(int index, V1beta3Subject item) {
        return new SubjectsNested(index, item);
    }

    public SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    public SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editMatchingSubject(Predicate<V1beta3SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta3PolicyRulesWithSubjectsFluent that = (V1beta3PolicyRulesWithSubjectsFluent)o;
        if (!Objects.equals(this.nonResourceRules, that.nonResourceRules)) {
            return false;
        }
        if (!Objects.equals(this.resourceRules, that.resourceRules)) {
            return false;
        }
        return Objects.equals(this.subjects, that.subjects);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonResourceRules, this.resourceRules, this.subjects, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nonResourceRules != null && !this.nonResourceRules.isEmpty()) {
            sb.append("nonResourceRules:");
            sb.append(this.nonResourceRules + ",");
        }
        if (this.resourceRules != null && !this.resourceRules.isEmpty()) {
            sb.append("resourceRules:");
            sb.append(this.resourceRules + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NonResourceRulesNested<N>
    extends V1beta3NonResourcePolicyRuleFluent<NonResourceRulesNested<N>>
    implements Nested<N> {
        V1beta3NonResourcePolicyRuleBuilder builder;
        int index;

        NonResourceRulesNested(int index, V1beta3NonResourcePolicyRule item) {
            this.index = index;
            this.builder = new V1beta3NonResourcePolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta3PolicyRulesWithSubjectsFluent.this.setToNonResourceRules(this.index, this.builder.build());
        }

        public N endNonResourceRule() {
            return this.and();
        }
    }

    public class ResourceRulesNested<N>
    extends V1beta3ResourcePolicyRuleFluent<ResourceRulesNested<N>>
    implements Nested<N> {
        V1beta3ResourcePolicyRuleBuilder builder;
        int index;

        ResourceRulesNested(int index, V1beta3ResourcePolicyRule item) {
            this.index = index;
            this.builder = new V1beta3ResourcePolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta3PolicyRulesWithSubjectsFluent.this.setToResourceRules(this.index, this.builder.build());
        }

        public N endResourceRule() {
            return this.and();
        }
    }

    public class SubjectsNested<N>
    extends V1beta3SubjectFluent<SubjectsNested<N>>
    implements Nested<N> {
        V1beta3SubjectBuilder builder;
        int index;

        SubjectsNested(int index, V1beta3Subject item) {
            this.index = index;
            this.builder = new V1beta3SubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta3PolicyRulesWithSubjectsFluent.this.setToSubjects(this.index, this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }
}

