/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha2DriverAllocationResult;
import io.kubernetes.client.openapi.models.V1alpha2DriverAllocationResultBuilder;
import io.kubernetes.client.openapi.models.V1alpha2DriverAllocationResultFluent;
import io.kubernetes.client.openapi.models.V1alpha2StructuredResourceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha2StructuredResourceHandleFluent<A extends V1alpha2StructuredResourceHandleFluent<A>>
extends BaseFluent<A> {
    private String nodeName;
    private ArrayList<V1alpha2DriverAllocationResultBuilder> results;
    private Object vendorClaimParameters;
    private Object vendorClassParameters;

    public V1alpha2StructuredResourceHandleFluent() {
    }

    public V1alpha2StructuredResourceHandleFluent(V1alpha2StructuredResourceHandle instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha2StructuredResourceHandle instance) {
        V1alpha2StructuredResourceHandle v1alpha2StructuredResourceHandle = instance = instance != null ? instance : new V1alpha2StructuredResourceHandle();
        if (instance != null) {
            this.withNodeName(instance.getNodeName());
            this.withResults(instance.getResults());
            this.withVendorClaimParameters(instance.getVendorClaimParameters());
            this.withVendorClassParameters(instance.getVendorClassParameters());
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A addToResults(int index, V1alpha2DriverAllocationResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        V1alpha2DriverAllocationResultBuilder builder = new V1alpha2DriverAllocationResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get("results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get("results").add(index, builder);
            this.results.add(index, builder);
        }
        return (A)this;
    }

    public A setToResults(int index, V1alpha2DriverAllocationResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        V1alpha2DriverAllocationResultBuilder builder = new V1alpha2DriverAllocationResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get("results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get("results").set(index, builder);
            this.results.set(index, builder);
        }
        return (A)this;
    }

    public A addToResults(V1alpha2DriverAllocationResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (V1alpha2DriverAllocationResult item : items) {
            V1alpha2DriverAllocationResultBuilder builder = new V1alpha2DriverAllocationResultBuilder(item);
            this._visitables.get("results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    public A addAllToResults(Collection<V1alpha2DriverAllocationResult> items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (V1alpha2DriverAllocationResult item : items) {
            V1alpha2DriverAllocationResultBuilder builder = new V1alpha2DriverAllocationResultBuilder(item);
            this._visitables.get("results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    public A removeFromResults(V1alpha2DriverAllocationResult ... items) {
        if (this.results == null) {
            return (A)this;
        }
        for (V1alpha2DriverAllocationResult item : items) {
            V1alpha2DriverAllocationResultBuilder builder = new V1alpha2DriverAllocationResultBuilder(item);
            this._visitables.get("results").remove(builder);
            this.results.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResults(Collection<V1alpha2DriverAllocationResult> items) {
        if (this.results == null) {
            return (A)this;
        }
        for (V1alpha2DriverAllocationResult item : items) {
            V1alpha2DriverAllocationResultBuilder builder = new V1alpha2DriverAllocationResultBuilder(item);
            this._visitables.get("results").remove(builder);
            this.results.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResults(Predicate<V1alpha2DriverAllocationResultBuilder> predicate) {
        if (this.results == null) {
            return (A)this;
        }
        Iterator<V1alpha2DriverAllocationResultBuilder> each = this.results.iterator();
        Object visitables = this._visitables.get("results");
        while (each.hasNext()) {
            V1alpha2DriverAllocationResultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha2DriverAllocationResult> buildResults() {
        return this.results != null ? V1alpha2StructuredResourceHandleFluent.build(this.results) : null;
    }

    public V1alpha2DriverAllocationResult buildResult(int index) {
        return this.results.get(index).build();
    }

    public V1alpha2DriverAllocationResult buildFirstResult() {
        return this.results.get(0).build();
    }

    public V1alpha2DriverAllocationResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    public V1alpha2DriverAllocationResult buildMatchingResult(Predicate<V1alpha2DriverAllocationResultBuilder> predicate) {
        for (V1alpha2DriverAllocationResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResult(Predicate<V1alpha2DriverAllocationResultBuilder> predicate) {
        for (V1alpha2DriverAllocationResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResults(List<V1alpha2DriverAllocationResult> results) {
        if (this.results != null) {
            this._visitables.get("results").clear();
        }
        if (results != null) {
            this.results = new ArrayList();
            for (V1alpha2DriverAllocationResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)this;
    }

    public A withResults(V1alpha2DriverAllocationResult ... results) {
        if (this.results != null) {
            this.results.clear();
            this._visitables.remove("results");
        }
        if (results != null) {
            for (V1alpha2DriverAllocationResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)this;
    }

    public boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    public ResultsNested<A> addNewResult() {
        return new ResultsNested(-1, null);
    }

    public ResultsNested<A> addNewResultLike(V1alpha2DriverAllocationResult item) {
        return new ResultsNested(-1, item);
    }

    public ResultsNested<A> setNewResultLike(int index, V1alpha2DriverAllocationResult item) {
        return new ResultsNested(index, item);
    }

    public ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException("Can't edit results. Index exceeds size.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException("Can't edit first results. The list is empty.");
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    public ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last results. The list is empty.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public ResultsNested<A> editMatchingResult(Predicate<V1alpha2DriverAllocationResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.test(this.results.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching results. No match found.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public Object getVendorClaimParameters() {
        return this.vendorClaimParameters;
    }

    public A withVendorClaimParameters(Object vendorClaimParameters) {
        this.vendorClaimParameters = vendorClaimParameters;
        return (A)this;
    }

    public boolean hasVendorClaimParameters() {
        return this.vendorClaimParameters != null;
    }

    public Object getVendorClassParameters() {
        return this.vendorClassParameters;
    }

    public A withVendorClassParameters(Object vendorClassParameters) {
        this.vendorClassParameters = vendorClassParameters;
        return (A)this;
    }

    public boolean hasVendorClassParameters() {
        return this.vendorClassParameters != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2StructuredResourceHandleFluent that = (V1alpha2StructuredResourceHandleFluent)o;
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.results, that.results)) {
            return false;
        }
        if (!Objects.equals(this.vendorClaimParameters, that.vendorClaimParameters)) {
            return false;
        }
        return Objects.equals(this.vendorClassParameters, that.vendorClassParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nodeName, this.results, this.vendorClaimParameters, this.vendorClassParameters, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.results != null && !this.results.isEmpty()) {
            sb.append("results:");
            sb.append(this.results + ",");
        }
        if (this.vendorClaimParameters != null) {
            sb.append("vendorClaimParameters:");
            sb.append(this.vendorClaimParameters + ",");
        }
        if (this.vendorClassParameters != null) {
            sb.append("vendorClassParameters:");
            sb.append(this.vendorClassParameters);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResultsNested<N>
    extends V1alpha2DriverAllocationResultFluent<ResultsNested<N>>
    implements Nested<N> {
        V1alpha2DriverAllocationResultBuilder builder;
        int index;

        ResultsNested(int index, V1alpha2DriverAllocationResult item) {
            this.index = index;
            this.builder = new V1alpha2DriverAllocationResultBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2StructuredResourceHandleFluent.this.setToResults(this.index, this.builder.build());
        }

        public N endResult() {
            return this.and();
        }
    }
}

