/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha2NamedResourcesResources;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceSlice provides information about available resources on individual nodes.")
public class V1alpha2ResourceSlice
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_DRIVER_NAME = "driverName";
    @SerializedName(value="driverName")
    private String driverName;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_NAMED_RESOURCES = "namedResources";
    @SerializedName(value="namedResources")
    private V1alpha2NamedResourcesResources namedResources;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    private String nodeName;

    public V1alpha2ResourceSlice apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha2ResourceSlice driverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    @ApiModelProperty(required=true, value="DriverName identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.")
    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public V1alpha2ResourceSlice kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha2ResourceSlice metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha2ResourceSlice namedResources(V1alpha2NamedResourcesResources namedResources) {
        this.namedResources = namedResources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2NamedResourcesResources getNamedResources() {
        return this.namedResources;
    }

    public void setNamedResources(V1alpha2NamedResourcesResources namedResources) {
        this.namedResources = namedResources;
    }

    public V1alpha2ResourceSlice nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeName identifies the node which provides the resources if they are local to a node.  A field selector can be used to list only ResourceSlice objects with a certain node name.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceSlice v1alpha2ResourceSlice = (V1alpha2ResourceSlice)o;
        return Objects.equals(this.apiVersion, v1alpha2ResourceSlice.apiVersion) && Objects.equals(this.driverName, v1alpha2ResourceSlice.driverName) && Objects.equals(this.kind, v1alpha2ResourceSlice.kind) && Objects.equals(this.metadata, v1alpha2ResourceSlice.metadata) && Objects.equals(this.namedResources, v1alpha2ResourceSlice.namedResources) && Objects.equals(this.nodeName, v1alpha2ResourceSlice.nodeName);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.namedResources, this.nodeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceSlice {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    driverName: ").append(this.toIndentedString(this.driverName)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    namedResources: ").append(this.toIndentedString(this.namedResources)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

