/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1HTTPIngressPathBuilder;
import io.kubernetes.client.openapi.models.V1HTTPIngressPathFluent;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1HTTPIngressRuleValueFluent<A extends V1HTTPIngressRuleValueFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1HTTPIngressPathBuilder> paths;

    public V1HTTPIngressRuleValueFluent() {
    }

    public V1HTTPIngressRuleValueFluent(V1HTTPIngressRuleValue instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1HTTPIngressRuleValue instance) {
        V1HTTPIngressRuleValue v1HTTPIngressRuleValue = instance = instance != null ? instance : new V1HTTPIngressRuleValue();
        if (instance != null) {
            this.withPaths(instance.getPaths());
        }
    }

    public A addToPaths(int index, V1HTTPIngressPath item) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
        if (index < 0 || index >= this.paths.size()) {
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        } else {
            this._visitables.get("paths").add(index, builder);
            this.paths.add(index, builder);
        }
        return (A)this;
    }

    public A setToPaths(int index, V1HTTPIngressPath item) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
        if (index < 0 || index >= this.paths.size()) {
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        } else {
            this._visitables.get("paths").set(index, builder);
            this.paths.set(index, builder);
        }
        return (A)this;
    }

    public A addToPaths(V1HTTPIngressPath ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        for (V1HTTPIngressPath item : items) {
            V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    public A addAllToPaths(Collection<V1HTTPIngressPath> items) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        for (V1HTTPIngressPath item : items) {
            V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    public A removeFromPaths(V1HTTPIngressPath ... items) {
        if (this.paths == null) {
            return (A)this;
        }
        for (V1HTTPIngressPath item : items) {
            V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
            this._visitables.get("paths").remove(builder);
            this.paths.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPaths(Collection<V1HTTPIngressPath> items) {
        if (this.paths == null) {
            return (A)this;
        }
        for (V1HTTPIngressPath item : items) {
            V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
            this._visitables.get("paths").remove(builder);
            this.paths.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPaths(Predicate<V1HTTPIngressPathBuilder> predicate) {
        if (this.paths == null) {
            return (A)this;
        }
        Iterator<V1HTTPIngressPathBuilder> each = this.paths.iterator();
        Object visitables = this._visitables.get("paths");
        while (each.hasNext()) {
            V1HTTPIngressPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1HTTPIngressPath> buildPaths() {
        return this.paths != null ? V1HTTPIngressRuleValueFluent.build(this.paths) : null;
    }

    public V1HTTPIngressPath buildPath(int index) {
        return this.paths.get(index).build();
    }

    public V1HTTPIngressPath buildFirstPath() {
        return this.paths.get(0).build();
    }

    public V1HTTPIngressPath buildLastPath() {
        return this.paths.get(this.paths.size() - 1).build();
    }

    public V1HTTPIngressPath buildMatchingPath(Predicate<V1HTTPIngressPathBuilder> predicate) {
        for (V1HTTPIngressPathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPath(Predicate<V1HTTPIngressPathBuilder> predicate) {
        for (V1HTTPIngressPathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPaths(List<V1HTTPIngressPath> paths) {
        if (this.paths != null) {
            this._visitables.get("paths").clear();
        }
        if (paths != null) {
            this.paths = new ArrayList();
            for (V1HTTPIngressPath item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    public A withPaths(V1HTTPIngressPath ... paths) {
        if (this.paths != null) {
            this.paths.clear();
            this._visitables.remove("paths");
        }
        if (paths != null) {
            for (V1HTTPIngressPath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    public boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    public PathsNested<A> addNewPath() {
        return new PathsNested(-1, null);
    }

    public PathsNested<A> addNewPathLike(V1HTTPIngressPath item) {
        return new PathsNested(-1, item);
    }

    public PathsNested<A> setNewPathLike(int index, V1HTTPIngressPath item) {
        return new PathsNested(index, item);
    }

    public PathsNested<A> editPath(int index) {
        if (this.paths.size() <= index) {
            throw new RuntimeException("Can't edit paths. Index exceeds size.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    public PathsNested<A> editFirstPath() {
        if (this.paths.size() == 0) {
            throw new RuntimeException("Can't edit first paths. The list is empty.");
        }
        return this.setNewPathLike(0, this.buildPath(0));
    }

    public PathsNested<A> editLastPath() {
        int index = this.paths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last paths. The list is empty.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    public PathsNested<A> editMatchingPath(Predicate<V1HTTPIngressPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.paths.size(); ++i) {
            if (!predicate.test(this.paths.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching paths. No match found.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HTTPIngressRuleValueFluent that = (V1HTTPIngressRuleValueFluent)o;
        return Objects.equals(this.paths, that.paths);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.paths, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.paths != null && !this.paths.isEmpty()) {
            sb.append("paths:");
            sb.append(this.paths);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PathsNested<N>
    extends V1HTTPIngressPathFluent<PathsNested<N>>
    implements Nested<N> {
        V1HTTPIngressPathBuilder builder;
        int index;

        PathsNested(int index, V1HTTPIngressPath item) {
            this.index = index;
            this.builder = new V1HTTPIngressPathBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1HTTPIngressRuleValueFluent.this.setToPaths(this.index, this.builder.build());
        }

        public N endPath() {
            return this.and();
        }
    }
}

