/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1APIServiceCondition;
import io.kubernetes.client.openapi.models.V1APIServiceConditionBuilder;
import io.kubernetes.client.openapi.models.V1APIServiceConditionFluent;
import io.kubernetes.client.openapi.models.V1APIServiceStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1APIServiceStatusFluent<A extends V1APIServiceStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1APIServiceConditionBuilder> conditions;

    public V1APIServiceStatusFluent() {
    }

    public V1APIServiceStatusFluent(V1APIServiceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1APIServiceStatus instance) {
        V1APIServiceStatus v1APIServiceStatus = instance = instance != null ? instance : new V1APIServiceStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
        }
    }

    public A addToConditions(int index, V1APIServiceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V1APIServiceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V1APIServiceCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1APIServiceCondition item : items) {
            V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V1APIServiceCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1APIServiceCondition item : items) {
            V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V1APIServiceCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1APIServiceCondition item : items) {
            V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V1APIServiceCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1APIServiceCondition item : items) {
            V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V1APIServiceConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1APIServiceConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1APIServiceConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1APIServiceCondition> buildConditions() {
        return this.conditions != null ? V1APIServiceStatusFluent.build(this.conditions) : null;
    }

    public V1APIServiceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1APIServiceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1APIServiceCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V1APIServiceCondition buildMatchingCondition(Predicate<V1APIServiceConditionBuilder> predicate) {
        for (V1APIServiceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V1APIServiceConditionBuilder> predicate) {
        for (V1APIServiceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V1APIServiceCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1APIServiceCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V1APIServiceCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1APIServiceCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V1APIServiceCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V1APIServiceCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V1APIServiceConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1APIServiceStatusFluent that = (V1APIServiceStatusFluent)o;
        return Objects.equals(this.conditions, that.conditions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V1APIServiceConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V1APIServiceConditionBuilder builder;
        int index;

        ConditionsNested(int index, V1APIServiceCondition item) {
            this.index = index;
            this.builder = new V1APIServiceConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1APIServiceStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

