/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1LabelSelectorRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1LabelSelectorRequirementFluent<A extends V1LabelSelectorRequirementFluent<A>>
extends BaseFluent<A> {
    private String key;
    private String operator;
    private List<String> values;

    public V1LabelSelectorRequirementFluent() {
    }

    public V1LabelSelectorRequirementFluent(V1LabelSelectorRequirement instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1LabelSelectorRequirement instance) {
        V1LabelSelectorRequirement v1LabelSelectorRequirement = instance = instance != null ? instance : new V1LabelSelectorRequirement();
        if (instance != null) {
            this.withKey(instance.getKey());
            this.withOperator(instance.getOperator());
            this.withValues(instance.getValues());
        }
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key = key;
        return (A)this;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public String getOperator() {
        return this.operator;
    }

    public A withOperator(String operator) {
        this.operator = operator;
        return (A)this;
    }

    public boolean hasOperator() {
        return this.operator != null;
    }

    public A addToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(index, item);
        return (A)this;
    }

    public A setToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.set(index, item);
        return (A)this;
    }

    public A addToValues(String ... items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    public A removeFromValues(String ... items) {
        if (this.values == null) {
            return (A)this;
        }
        for (String item : items) {
            this.values.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromValues(Collection<String> items) {
        if (this.values == null) {
            return (A)this;
        }
        for (String item : items) {
            this.values.remove(item);
        }
        return (A)this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public String getFirstValue() {
        return this.values.get(0);
    }

    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    public String getMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValues(List<String> values) {
        if (values != null) {
            this.values = new ArrayList<String>();
            for (String item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)this;
    }

    public A withValues(String ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove("values");
        }
        if (values != null) {
            for (String item : values) {
                this.addToValues(item);
            }
        }
        return (A)this;
    }

    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1LabelSelectorRequirementFluent that = (V1LabelSelectorRequirementFluent)o;
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.operator, that.operator)) {
            return false;
        }
        return Objects.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.operator, this.values, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key + ",");
        }
        if (this.operator != null) {
            sb.append("operator:");
            sb.append(this.operator + ",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values);
        }
        sb.append("}");
        return sb.toString();
    }
}

